/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.notion;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.PropertiesNotFoundToken;
import org.structr.common.error.TypeToken;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.notion.DeserializationStrategy;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.RelationProperty;

public class TypeAndValueDeserializationStrategy<S, T extends NodeInterface>
implements DeserializationStrategy<S, T> {
    private static final Logger logger = LoggerFactory.getLogger((String)TypeAndValueDeserializationStrategy.class.getName());
    protected RelationProperty<S> relationProperty = null;
    protected boolean createIfNotExisting = false;
    protected PropertyKey propertyKey = null;

    public TypeAndValueDeserializationStrategy(PropertyKey propertyKey, boolean createIfNotExisting) {
        this.createIfNotExisting = createIfNotExisting;
        this.propertyKey = propertyKey;
    }

    @Override
    public void setRelationProperty(RelationProperty<S> relationProperty) {
        this.relationProperty = relationProperty;
    }

    @Override
    public T deserialize(SecurityContext securityContext, Class<T> type, S source, Object context) throws FrameworkException {
        App app = StructrApp.getInstance(securityContext);
        Result<T> result = Result.EMPTY_RESULT;
        if (this.propertyKey == null) {
            this.propertyKey = GraphObject.id;
        }
        LinkedHashMap<String, Object> sourceMap = new LinkedHashMap<String, Object>();
        sourceMap.put(this.propertyKey.jsonName(), source);
        PropertyMap convertedSourceMap = PropertyMap.inputTypeToJavaType(securityContext, type, sourceMap);
        Object convertedSource = convertedSourceMap.get(this.propertyKey);
        if (convertedSource != null) {
            if (convertedSource instanceof Map) {
                Object value = ((Map)convertedSource).get(this.propertyKey.jsonName());
                if (value != null) {
                    result = app.nodeQuery(type).and(this.propertyKey, value.toString()).getResult();
                }
            } else if (convertedSource instanceof GraphObject) {
                GraphObject obj = (GraphObject)convertedSource;
                result = app.nodeQuery(type).and(this.propertyKey, obj.getProperty(this.propertyKey)).getResult();
            } else {
                result = app.nodeQuery(type).and(this.propertyKey, convertedSource).getResult();
            }
        }
        int resultCount = result.size();
        switch (resultCount) {
            case 0: {
                if (convertedSource != null && this.createIfNotExisting) {
                    Object newNode = app.create(type, new NodeAttribute[0]);
                    if (newNode == null) break;
                    newNode.setProperty(this.propertyKey, convertedSource);
                    return newNode;
                }
                logger.warn("Unable to create node of type {} for property {}", new Object[]{type.getSimpleName(), this.propertyKey.jsonName()});
                break;
            }
            case 1: {
                NodeInterface obj = (NodeInterface)result.get(0);
                if (!type.isAssignableFrom(obj.getClass())) {
                    throw new FrameworkException(422, "Node type mismatch", new TypeToken(obj.getClass(), this.propertyKey, type.getSimpleName()));
                }
                if (!convertedSourceMap.isEmpty()) {
                    this.setProperties(securityContext, obj, convertedSourceMap);
                }
                return (T)obj;
            }
        }
        if (convertedSource != null) {
            PropertyMap attributes = new PropertyMap();
            attributes.put(this.propertyKey, convertedSource);
            attributes.put(AbstractNode.type, type.getSimpleName());
            throw new FrameworkException(404, "No node found for given properties", new PropertiesNotFoundToken(type.getSimpleName(), null, attributes));
        }
        return null;
    }
}

