/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import java.util.List;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.parser.Expression;
import org.structr.schema.action.ActionContext;

public class AnyExpression
extends Expression {
    public static final String ERROR_MESSAGE_ANY = "Usage: ${any(collection, expression)}. Example: ${any(user.groups, is_allowed(data, current, 'read'))}";
    private Expression listExpression = null;
    private Expression anyExpression = null;

    public AnyExpression() {
        super("any");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("any(");
        for (Expression expr : this.expressions) {
            buf.append(expr.toString());
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public void add(Expression expression) throws FrameworkException {
        if (this.listExpression == null) {
            this.listExpression = expression;
        } else if (this.anyExpression == null) {
            this.anyExpression = expression;
        } else {
            throw new FrameworkException(422, "Invalid any() expression in builtin function: too many parameters.");
        }
        expression.parent = this;
        expression.level = this.level + 1;
    }

    @Override
    public Object evaluate(ActionContext ctx, GraphObject entity) throws FrameworkException, UnlicensedException {
        if (this.listExpression == null) {
            return ERROR_MESSAGE_ANY;
        }
        Object listSource = this.listExpression.evaluate(ctx, entity);
        if (listSource != null && listSource instanceof List) {
            List source = (List)listSource;
            Object oldDataValue = ctx.getConstant("data");
            for (Object obj : source) {
                ctx.setConstant("data", obj);
                Object resultObject = this.anyExpression.evaluate(ctx, entity);
                if (resultObject == null || !(resultObject instanceof Boolean ? (Boolean)resultObject != false : Boolean.valueOf(resultObject.toString()) != false)) continue;
                return true;
            }
            ctx.setConstant("data", oldDataValue);
        }
        return false;
    }

    @Override
    public Object transform(ActionContext ctx, GraphObject entity, Object source) throws FrameworkException, UnlicensedException {
        return source;
    }
}

