/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.parser.Expression;
import org.structr.schema.action.ActionContext;

public class ArrayExpression
extends Expression {
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (Expression expr : this.expressions) {
            buf.append(expr.toString());
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void add(Expression expression) throws FrameworkException {
        if (!this.expressions.isEmpty()) {
            throw new FrameworkException(422, "Invalid expression: expected ], found another expression.");
        }
        super.add(expression);
    }

    @Override
    public Object evaluate(ActionContext ctx, GraphObject entity) throws FrameworkException, UnlicensedException {
        switch (this.expressions.size()) {
            case 0: {
                throw new FrameworkException(422, "Invalid expression: expected expression, found ].");
            }
            case 1: {
                Object value = ((Expression)this.expressions.get(0)).evaluate(ctx, entity);
                if (!(value instanceof Number)) break;
                return ((Number)value).intValue();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object transform(ActionContext ctx, GraphObject entity, Object value) throws FrameworkException, UnlicensedException {
        if (value == null) {
            return null;
        }
        Integer index = (Integer)this.evaluate(ctx, entity);
        if (index == null) throw new FrameworkException(422, "Invalid expression: invalid array index: null.");
        if (!(value instanceof Collection) && !value.getClass().isArray()) throw new FrameworkException(422, "Invalid expression: expected collection, found " + value.getClass().getSimpleName() + ".");
        try {
            return CollectionUtils.get((Object)value, (int)index);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

