/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import java.util.LinkedList;
import java.util.List;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.parser.Expression;
import org.structr.schema.action.ActionContext;

public class FilterExpression
extends Expression {
    public static final String ERROR_MESSAGE_FILTER = "Usage: ${filter(list, expression)}. Example: ${filter(this.children, gt(size(data.children), 0))}";
    private Expression listExpression = null;
    private Expression filterExpression = null;

    public FilterExpression() {
        super("filter");
    }

    @Override
    public void add(Expression expression) throws FrameworkException {
        if (this.listExpression == null) {
            this.listExpression = expression;
        } else if (this.filterExpression == null) {
            this.filterExpression = expression;
        } else {
            throw new FrameworkException(422, "Invalid filter() expression in builtin function: too many parameters.");
        }
        expression.parent = this;
        expression.level = this.level + 1;
    }

    @Override
    public Object evaluate(ActionContext ctx, GraphObject entity) throws FrameworkException, UnlicensedException {
        if (this.listExpression == null || this.filterExpression == null) {
            return ERROR_MESSAGE_FILTER;
        }
        Object listSource = this.listExpression.evaluate(ctx, entity);
        LinkedList target = new LinkedList();
        if (listSource != null && listSource instanceof List) {
            List source = (List)listSource;
            Object oldDataValue = ctx.getConstant("data");
            for (Object obj : source) {
                ctx.setConstant("data", obj);
                Object result = this.filterExpression.evaluate(ctx, entity);
                if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
                target.add(obj);
            }
            ctx.setConstant("data", oldDataValue);
        }
        return target;
    }

    @Override
    public Object transform(ActionContext ctx, GraphObject entity, Object source) throws FrameworkException, UnlicensedException {
        return source;
    }
}

