/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import java.util.ArrayList;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.function.BatchableFunction;
import org.structr.core.graph.Tx;
import org.structr.core.parser.Expression;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class FunctionExpression
extends Expression {
    private Function<Object, Object> function = null;

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("function(");
        for (Expression expr : this.expressions) {
            buf.append(expr.toString());
        }
        buf.append(")");
        return buf.toString();
    }

    public FunctionExpression(String name, Function<Object, Object> function) {
        super(name);
        this.function = function;
    }

    @Override
    public Object evaluate(ActionContext ctx, GraphObject entity) throws FrameworkException, UnlicensedException {
        Object result;
        ArrayList<Object> results = new ArrayList<Object>();
        for (Expression expr : this.expressions) {
            result = expr.evaluate(ctx, entity);
            results.add(result);
        }
        if (results.isEmpty() && this.expressions.size() > 0) {
            return this.function.usage(ctx.isJavaScriptContext());
        }
        if (this.function instanceof BatchableFunction) {
            ((BatchableFunction)((Object)this.function)).setBatchSize(this.getBatchSize());
            ((BatchableFunction)((Object)this.function)).setBatched(this.isBatched());
            return this.function.apply(ctx, entity, (Object[])results.toArray());
        }
        if (this.isBatched()) {
            try (Tx tx = StructrApp.getInstance(ctx.getSecurityContext()).tx();){
                result = this.function.apply(ctx, entity, (Object[])results.toArray());
                tx.success();
                Object object = result;
                return object;
            }
        }
        return this.function.apply(ctx, entity, (Object[])results.toArray());
    }

    @Override
    public Object transform(ActionContext ctx, GraphObject entity, Object source) throws FrameworkException, UnlicensedException {
        return source;
    }
}

