/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.predicate;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.graph.Node;
import org.structr.core.entity.AbstractNode;

public class TypePredicate
implements Predicate<Node> {
    private static final Logger logger = LoggerFactory.getLogger((String)TypePredicate.class.getName());
    private String type = null;

    public TypePredicate(String type) {
        this.type = type;
    }

    public boolean accept(Node node) {
        if (node.hasProperty(AbstractNode.type.dbName())) {
            String value = (String)node.getProperty(AbstractNode.type.dbName());
            logger.debug("Type property: {}, expected {}", new Object[]{value, this.type});
            return this.type.equals(value);
        }
        logger.warn("Node has no type property.");
        return false;
    }
}

