/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.ReadOnlyPropertyToken;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.Property;

public abstract class AbstractReadOnlyProperty<T>
extends Property<T> {
    public AbstractReadOnlyProperty(String name) {
        this(name, name);
    }

    public AbstractReadOnlyProperty(String name, T defaultValue) {
        this(name, name, defaultValue);
    }

    public AbstractReadOnlyProperty(String jsonName, String dbName) {
        this(jsonName, dbName, null);
    }

    public AbstractReadOnlyProperty(String jsonName, String dbName, T defaultValue) {
        super(jsonName, dbName, defaultValue);
    }

    @Override
    public Property<T> indexed() {
        super.passivelyIndexed();
        return this;
    }

    @Override
    public String typeName() {
        return "";
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        return value;
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, T value) throws FrameworkException {
        throw new FrameworkException(422, "Property " + this.jsonName() + " is read-only", new ReadOnlyPropertyToken(obj.getClass().getSimpleName(), this));
    }

    @Override
    public PropertyConverter<T, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<T, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, T> inputConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

