/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.converter.Aggregation;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.notion.Notion;
import org.structr.core.property.AbstractReadOnlyCollectionProperty;
import org.structr.core.property.Property;

public class AggregatorProperty<T>
extends AbstractReadOnlyCollectionProperty<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)AggregatorProperty.class.getName());
    private Aggregation aggregation = null;

    public AggregatorProperty(String name, Aggregation aggregator) {
        super(name);
        this.aggregation = aggregator;
    }

    @Override
    public List<T> getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public List<T> getProperty(SecurityContext securityContext, GraphObject currentObject, boolean applyConverter, Predicate<GraphObject> predicate) {
        if (currentObject != null && currentObject instanceof AbstractNode) {
            NodeInterface sourceNode = (NodeInterface)currentObject;
            LinkedList nodes = new LinkedList();
            for (Property property : this.aggregation.getAggregationProperties()) {
                Object obj = sourceNode.getProperty(property);
                if (obj == null || !(obj instanceof Collection)) continue;
                nodes.addAll((Collection)obj);
            }
            Comparator<NodeInterface> comparator = this.aggregation.getComparator();
            if (nodes.isEmpty() && comparator != null) {
                Collections.sort(nodes, comparator);
            }
            LinkedList<Object> results = new LinkedList<Object>();
            try {
                for (NodeInterface node : nodes) {
                    Notion notion = this.aggregation.getNotionForType(node.getClass());
                    if (notion != null) {
                        results.add(notion.getAdapterForGetter(securityContext).adapt(node));
                        continue;
                    }
                    results.add(node);
                }
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
            return results;
        }
        return Collections.emptyList();
    }

    @Override
    public Class relatedType() {
        return AbstractNode.class;
    }

    @Override
    public Class valueType() {
        return this.relatedType();
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }
}

