/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.search.Occurrence;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.Query;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.graph.search.ArraySearchAttribute;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.graph.search.SearchAttributeGroup;
import org.structr.core.property.AbstractPrimitiveProperty;

public class ArrayProperty<T>
extends AbstractPrimitiveProperty<T[]> {
    private static final Logger logger = LoggerFactory.getLogger((String)ArrayProperty.class.getName());
    private Class<T> componentType = null;
    private Method valueOfMethod = null;

    public ArrayProperty(String name, Class<T> componentType) {
        super(name);
        this.componentType = componentType;
        this.valueOfMethod = this.methodOrNull();
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        if (value != null && value instanceof String) {
            String[] fixedValue = null;
            String stringValue = (String)value;
            if (stringValue.contains(",")) {
                fixedValue = stringValue.split(",");
            }
            if (stringValue.contains(" ")) {
                fixedValue = stringValue.split(" ");
            }
            if (this.securityContext != null && this.entity != null) {
                try {
                    this.setProperty(this.securityContext, this.entity, (Object[])fixedValue);
                }
                catch (FrameworkException ex) {
                    logger.warn("", (Throwable)ex);
                }
            }
            return fixedValue;
        }
        return value;
    }

    @Override
    public String typeName() {
        return this.componentType.getSimpleName().concat("[]");
    }

    @Override
    public Class valueType() {
        return this.componentType;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public PropertyConverter<T[], ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<T[], ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        this.securityContext = securityContext;
        this.entity = entity;
        return null;
    }

    @Override
    public PropertyConverter<?, T[]> inputConverter(SecurityContext securityContext) {
        return new ArrayInputConverter(securityContext);
    }

    @Override
    public SearchAttribute getSearchAttribute(SecurityContext securityContext, Occurrence occur, T[] searchValue, boolean exactMatch, Query query) {
        if (searchValue == null) {
            return new ArraySearchAttribute<String>(this, "", exactMatch ? occur : Occurrence.OPTIONAL, exactMatch);
        }
        SearchAttributeGroup group = new SearchAttributeGroup(occur);
        for (T value : searchValue) {
            group.add(new ArraySearchAttribute<T[]>(this, (T[])value, exactMatch ? occur : Occurrence.OPTIONAL, exactMatch));
        }
        return group;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    private T[] convert(List source) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object o : source) {
            if (this.componentType.isInstance(o)) {
                result.add(o);
                continue;
            }
            if (o != null) {
                result.add(this.fromString(o.toString()));
                continue;
            }
            throw new IllegalStateException("Conversion of array type failed.");
        }
        return result.toArray((Object[])Array.newInstance(this.componentType, 0));
    }

    private T fromString(String source) {
        if (this.valueOfMethod != null) {
            try {
                return (T)this.valueOfMethod.invoke(null, source);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return (T)source;
    }

    private Method methodOrNull() {
        try {
            return this.componentType.getDeclaredMethod("valueOf", String.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private class ArrayInputConverter
    extends PropertyConverter<Object, T[]> {
        public ArrayInputConverter(SecurityContext securityContext) {
            super(securityContext, null);
        }

        @Override
        public Object revert(Object[] source) throws FrameworkException {
            return source != null ? Arrays.asList(source) : null;
        }

        @Override
        public T[] convert(Object source) throws FrameworkException {
            String s;
            if (source == null) {
                return null;
            }
            if (source instanceof List) {
                return ArrayProperty.this.convert((List)source);
            }
            if (source.getClass().isArray()) {
                return this.convert(Arrays.asList((Object[])source));
            }
            if (source instanceof String && (s = (String)source).contains(",")) {
                return ArrayProperty.this.convert(Arrays.asList(s.split(",")));
            }
            Object[] result = (Object[])Array.newInstance(ArrayProperty.this.componentType, 1);
            Object value = ArrayProperty.this.fromString(source.toString());
            if (value != null) {
                result[0] = value;
            }
            return result;
        }
    }
}

