/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.property.StringProperty;

public abstract class AutoStringProperty
extends StringProperty {
    private static final Logger logger = LoggerFactory.getLogger((String)AutoStringProperty.class.getName());

    public AutoStringProperty(String name) {
        super(name);
        this.passivelyIndexed();
    }

    public abstract String createValue(GraphObject var1);

    @Override
    public void index(GraphObject entity, Object value) {
        Object indexValue = value;
        if (indexValue == null && (indexValue = this.createValue(entity)) != null) {
            try {
                entity.setProperty(this, (String)indexValue);
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to set value {} on entity {}: {}", new Object[]{indexValue, entity, fex.getMessage()});
            }
        }
        super.index(entity, indexValue);
    }
}

