/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.search.Occurrence;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.Query;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.graph.search.ArraySearchAttribute;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.graph.search.SearchAttributeGroup;
import org.structr.core.property.AbstractPrimitiveProperty;

public class BooleanArrayProperty
extends AbstractPrimitiveProperty<Boolean[]> {
    private static final Logger logger = LoggerFactory.getLogger((String)BooleanArrayProperty.class.getName());

    public BooleanArrayProperty(String name) {
        super(name);
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        if (value != null && value instanceof String) {
            String[] fixedValue = null;
            String stringValue = (String)value;
            if (stringValue.contains(",")) {
                fixedValue = stringValue.split(",");
            }
            if (stringValue.contains(" ")) {
                fixedValue = stringValue.split(" ");
            }
            if (this.securityContext != null && this.entity != null) {
                try {
                    this.setProperty(this.securityContext, this.entity, this.convert(Arrays.asList(fixedValue)));
                }
                catch (FrameworkException ex) {
                    logger.warn("", (Throwable)ex);
                }
            }
            return fixedValue;
        }
        return value;
    }

    @Override
    public String typeName() {
        return "Boolean[]";
    }

    @Override
    public Class valueType() {
        return Boolean.class;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public PropertyConverter<Boolean[], ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<Boolean[], ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        this.securityContext = securityContext;
        this.entity = entity;
        return null;
    }

    @Override
    public PropertyConverter<?, Boolean[]> inputConverter(SecurityContext securityContext) {
        return new ArrayInputConverter(securityContext);
    }

    @Override
    public SearchAttribute getSearchAttribute(SecurityContext securityContext, Occurrence occur, Boolean[] searchValue, boolean exactMatch, Query query) {
        if (searchValue == null) {
            return new ArraySearchAttribute<String>(this, "", exactMatch ? occur : Occurrence.OPTIONAL, exactMatch);
        }
        SearchAttributeGroup group = new SearchAttributeGroup(occur);
        for (Boolean value : searchValue) {
            group.add(new ArraySearchAttribute<Boolean>(this, value, exactMatch ? occur : Occurrence.OPTIONAL, exactMatch));
        }
        return group;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    private Boolean[] convert(List source) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object o : source) {
            if (o instanceof Boolean) {
                result.add((Boolean)o);
                continue;
            }
            if (o != null) {
                result.add(Boolean.valueOf(o.toString()));
                continue;
            }
            throw new IllegalStateException("Conversion of array type failed.");
        }
        return result.toArray(new Boolean[0]);
    }

    private class ArrayInputConverter
    extends PropertyConverter<Object, Boolean[]> {
        public ArrayInputConverter(SecurityContext securityContext) {
            super(securityContext, null);
        }

        @Override
        public Object revert(Boolean[] source) throws FrameworkException {
            return source != null ? Arrays.asList(source) : null;
        }

        @Override
        public Boolean[] convert(Object source) throws FrameworkException {
            if (source == null) {
                return null;
            }
            if (source instanceof List) {
                return BooleanArrayProperty.this.convert((List)source);
            }
            if (source.getClass().isArray()) {
                return this.convert(Arrays.asList((Boolean[])source));
            }
            if (source instanceof String) {
                String s = (String)source;
                if (s.contains(",")) {
                    return BooleanArrayProperty.this.convert(Arrays.asList(s.split(",")));
                }
                if (StringUtils.isBlank((CharSequence)s)) {
                    return null;
                }
            }
            return new Boolean[]{Boolean.valueOf(source.toString())};
        }
    }
}

