/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.search.Occurrence;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.search.EmptySearchAttribute;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.graph.search.SourceSearchAttribute;
import org.structr.core.notion.Notion;
import org.structr.core.property.CollectionIdProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;

public class CollectionNotionProperty<S extends NodeInterface, T>
extends Property<List<T>> {
    private static final Logger logger = LoggerFactory.getLogger((String)CollectionIdProperty.class.getName());
    private Property<List<S>> collectionProperty = null;
    private Notion<S, T> notion = null;

    public CollectionNotionProperty(String name, Property<List<S>> base, Notion<S, T> notion) {
        super(name);
        this.notion = notion;
        this.collectionProperty = base;
        notion.setType(base.relatedType());
    }

    @Override
    public Property<List<T>> indexed() {
        return this;
    }

    @Override
    public Property<List<T>> passivelyIndexed() {
        return this;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        return null;
    }

    @Override
    public String typeName() {
        return "";
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public PropertyConverter<List<T>, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<List<T>, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, List<T>> inputConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public List<T> getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public List<T> getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        try {
            return this.notion.getCollectionAdapterForGetter(securityContext).adapt(this.collectionProperty.getProperty(securityContext, obj, applyConverter, predicate));
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to apply notion of type {} to property {}", new Object[]{this.notion.getClass(), this});
            return null;
        }
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, List<T> value) throws FrameworkException {
        if (value != null) {
            return this.collectionProperty.setProperty(securityContext, obj, this.notion.getCollectionAdapterForSetter(securityContext).adapt(value));
        }
        return this.collectionProperty.setProperty(securityContext, obj, null);
    }

    @Override
    public Class relatedType() {
        return this.collectionProperty.relatedType();
    }

    @Override
    public Class valueType() {
        return this.relatedType();
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public List<T> convertSearchValue(SecurityContext securityContext, String requestParameter) throws FrameworkException {
        LinkedList<Object> list;
        block4: {
            PropertyKey<T> propertyKey = this.notion.getPrimaryPropertyKey();
            list = new LinkedList<Object>();
            if (propertyKey == null) break block4;
            PropertyConverter<?, T> inputConverter = propertyKey.inputConverter(securityContext);
            if (inputConverter != null) {
                for (String part : requestParameter.split("[,;]+")) {
                    list.add(inputConverter.convert(part));
                }
            } else {
                for (String part : requestParameter.split("[,;]+")) {
                    list.add(part);
                }
            }
        }
        return list;
    }

    @Override
    public SearchAttribute getSearchAttribute(SecurityContext securityContext, Occurrence occur, List<T> searchValues, boolean exactMatch, Query query) {
        Predicate<GraphObject> predicate = query != null ? query.toPredicate() : null;
        SourceSearchAttribute attr = new SourceSearchAttribute(occur);
        LinkedHashSet<GraphObject> intersectionResult = new LinkedHashSet<GraphObject>();
        boolean alreadyAdded = false;
        try {
            if (searchValues != null && !searchValues.isEmpty()) {
                PropertyKey<T> key = this.notion.getPrimaryPropertyKey();
                PropertyConverter<?, T> inputConverter = key.inputConverter(securityContext);
                LinkedList<T> transformedValues = new LinkedList<T>();
                boolean allBlank = true;
                for (Object searchValue : searchValues) {
                    if (inputConverter != null) {
                        transformedValues.add(inputConverter.convert(searchValue));
                        continue;
                    }
                    transformedValues.add(searchValue);
                }
                for (Object searchValue : transformedValues) {
                    Result result;
                    if (StringUtils.isBlank((CharSequence)searchValue.toString())) continue;
                    allBlank = false;
                    App app = StructrApp.getInstance(securityContext);
                    if (exactMatch) {
                        result = app.nodeQuery(this.collectionProperty.relatedType()).and(this.notion.getPrimaryPropertyKey(), searchValue).getResult();
                        for (AbstractNode node : result.getResults()) {
                            switch (occur) {
                                case REQUIRED: {
                                    if (!alreadyAdded) {
                                        intersectionResult.addAll(this.collectionProperty.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                                        alreadyAdded = true;
                                        break;
                                    }
                                    intersectionResult.retainAll(this.collectionProperty.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                                    break;
                                }
                                case OPTIONAL: {
                                    intersectionResult.addAll(this.collectionProperty.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                                    break;
                                }
                            }
                        }
                        continue;
                    }
                    result = app.nodeQuery(this.collectionProperty.relatedType()).and(this.notion.getPrimaryPropertyKey(), searchValue, false).getResult();
                    for (AbstractNode node : result.getResults()) {
                        intersectionResult.addAll(this.collectionProperty.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                    }
                }
                if (allBlank) {
                    return new EmptySearchAttribute(this, Collections.emptyList());
                }
            } else {
                return new EmptySearchAttribute(this, Collections.emptyList());
            }
            attr.setResult(intersectionResult);
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return attr;
    }

    @Override
    public void index(GraphObject entity, Object value) {
    }

    @Override
    public int getProcessingOrderPosition() {
        return 1000;
    }

    @Override
    protected boolean multiValueSplitAllowed() {
        return false;
    }
}

