/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.property.AbstractReadOnlyProperty;
import org.structr.core.property.PropertyKey;

public class ConcatProperty
extends AbstractReadOnlyProperty<String> {
    private PropertyKey<String>[] propertyKeys = null;
    private String separator = null;

    public ConcatProperty(String name, String separator, PropertyKey<String> ... propertyKeys) {
        super(name);
        this.propertyKeys = propertyKeys;
        this.separator = separator;
    }

    @Override
    public String getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public String getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        StringBuilder combinedPropertyValue = new StringBuilder();
        int len = this.propertyKeys.length;
        for (int i = 0; i < len; ++i) {
            combinedPropertyValue.append(obj.getProperty(this.propertyKeys[i]));
            if (i >= len - 1) continue;
            combinedPropertyValue.append(this.separator);
        }
        return combinedPropertyValue.toString();
    }

    @Override
    public Class relatedType() {
        return null;
    }

    @Override
    public Class valueType() {
        return String.class;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }
}

