/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.CypherQueryCommand;
import org.structr.core.property.AbstractReadOnlyProperty;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;

public class CypherQueryProperty
extends AbstractReadOnlyProperty<List<GraphObject>> {
    private static final Logger logger = LoggerFactory.getLogger((String)CypherQueryProperty.class.getName());

    public CypherQueryProperty(String name, String cypherQuery) {
        super(name);
        this.format = cypherQuery;
    }

    @Override
    public Class relatedType() {
        return null;
    }

    @Override
    public Class valueType() {
        return GraphObject.class;
    }

    @Override
    public List<GraphObject> getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public List<GraphObject> getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        if (obj instanceof AbstractNode) {
            try {
                String query = Scripting.replaceVariables(new ActionContext(securityContext), obj, this.format);
                LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
                parameters.put("id", obj.getUuid());
                parameters.put("type", obj.getType());
                return StructrApp.getInstance(securityContext).command(CypherQueryCommand.class).execute(query, parameters);
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        return null;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }
}

