/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.Date;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.commons.lang3.StringUtils;
import org.structr.api.config.Settings;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.DateFormatToken;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.AbstractPrimitiveProperty;
import org.structr.schema.parser.DatePropertyParser;

public class DateProperty
extends AbstractPrimitiveProperty<Date> {
    public DateProperty(String name) {
        super(name);
        this.format = DateProperty.getDefaultFormat();
    }

    public DateProperty(String jsonName, String dbName) {
        super(jsonName, dbName);
        this.format = DateProperty.getDefaultFormat();
    }

    public DateProperty(String jsonName, String dbName, String format) {
        super(jsonName);
        this.format = StringUtils.isNotBlank((CharSequence)format) ? format : DateProperty.getDefaultFormat();
    }

    @Override
    public String typeName() {
        return "Date";
    }

    @Override
    public Class valueType() {
        return Date.class;
    }

    @Override
    public SortType getSortType() {
        return SortType.Long;
    }

    @Override
    public PropertyConverter<Date, Long> databaseConverter(SecurityContext securityContext) {
        return this.databaseConverter(securityContext, null);
    }

    @Override
    public PropertyConverter<Date, Long> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return new DatabaseConverter(securityContext, entity);
    }

    @Override
    public PropertyConverter<String, Date> inputConverter(SecurityContext securityContext) {
        return new InputConverter(securityContext);
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        if (value != null) {
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            try {
                return Long.parseLong(value.toString());
            }
            catch (Throwable throwable) {
                try {
                    return DatePropertyParser.parse(value.toString(), this.format).getTime();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public PropertyType getDataType() {
        return PropertyType.DATETIME;
    }

    public static String getDefaultFormat() {
        return (String)Settings.DefaultDateFormat.getValue();
    }

    private class InputConverter
    extends PropertyConverter<String, Date> {
        public InputConverter(SecurityContext securityContext) {
            super(securityContext, null);
        }

        @Override
        public Date convert(String source) throws FrameworkException {
            if (StringUtils.isNotBlank((CharSequence)source)) {
                Date result = DatePropertyParser.parse(source, DateProperty.this.format);
                if (result != null) {
                    return result;
                }
                throw new FrameworkException(422, "Cannot parse input for property " + DateProperty.this.jsonName(), new DateFormatToken(DateProperty.this.declaringClass.getSimpleName(), DateProperty.this));
            }
            return null;
        }

        @Override
        public String revert(Date source) throws FrameworkException {
            return DatePropertyParser.format(source, DateProperty.this.format);
        }
    }

    private class DatabaseConverter
    extends PropertyConverter<Date, Long> {
        public DatabaseConverter(SecurityContext securityContext, GraphObject entity) {
            super(securityContext, entity);
        }

        @Override
        public Long convert(Date source) throws FrameworkException {
            if (source != null) {
                return source.getTime();
            }
            return null;
        }

        @Override
        public Date revert(Long source) throws FrameworkException {
            if (source != null) {
                return new Date(source);
            }
            return null;
        }
    }
}

