/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.AbstractReadOnlyProperty;
import org.structr.core.property.Property;

public class ElementCounter
extends AbstractReadOnlyProperty<Integer> {
    private Property<? extends Iterable> collectionProperty = null;

    public ElementCounter(String name, Property<? extends Iterable> collectionProperty) {
        super(name);
        this.collectionProperty = collectionProperty;
    }

    @Override
    public Integer getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public Integer getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        Iterable toCount;
        int count = 0;
        if (obj != null && (toCount = obj.getProperty(this.collectionProperty)) != null) {
            if (toCount instanceof Collection) {
                count = ((Collection)toCount).size();
            } else if (toCount instanceof Iterable) {
                for (Object o : toCount) {
                    ++count;
                }
            } else {
                count = 1;
            }
        }
        return count;
    }

    @Override
    public Class relatedType() {
        return null;
    }

    @Override
    public Class valueType() {
        return Integer.class;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public SortType getSortType() {
        return SortType.Integer;
    }

    @Override
    public PropertyConverter<?, Integer> inputConverter(SecurityContext securityContext) {
        return new InputConverter(securityContext);
    }

    protected class InputConverter
    extends PropertyConverter<Object, Integer> {
        public InputConverter(SecurityContext securityContext) {
            super(securityContext, null);
        }

        @Override
        public Object revert(Integer source) throws FrameworkException {
            return source;
        }

        @Override
        public Integer convert(Object source) {
            if (source == null) {
                return null;
            }
            if (source instanceof Number) {
                return ((Number)source).intValue();
            }
            if (source instanceof String && StringUtils.isNotBlank((CharSequence)((String)source))) {
                return Integer.parseInt(source.toString());
            }
            return null;
        }
    }
}

