/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.search.Occurrence;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.OneEndpoint;
import org.structr.core.entity.Relation;
import org.structr.core.entity.Source;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.search.EmptySearchAttribute;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.graph.search.SourceSearchAttribute;
import org.structr.core.notion.Notion;
import org.structr.core.notion.ObjectNotion;
import org.structr.core.property.Property;
import org.structr.core.property.RelationProperty;

public class EndNode<S extends NodeInterface, T extends NodeInterface>
extends Property<T>
implements RelationProperty<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)EndNode.class.getName());
    private Relation<S, T, ? extends Source, OneEndpoint<T>> relation = null;
    private Notion notion = null;
    private Class<T> destType = null;

    public EndNode(String name, Class<? extends Relation<S, T, ? extends Source, OneEndpoint<T>>> relationClass) {
        this(name, relationClass, new ObjectNotion());
    }

    public EndNode(String name, Class<? extends Relation<S, T, ? extends Source, OneEndpoint<T>>> relationClass, Notion notion) {
        super(name);
        try {
            this.relation = relationClass.newInstance();
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        this.notion = notion;
        this.destType = this.relation.getTargetType();
        this.notion.setType(this.destType);
        this.notion.setRelationProperty(this);
        StructrApp.getConfiguration().registerConvertedProperty(this);
    }

    @Override
    public String typeName() {
        return "object";
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public PropertyConverter<T, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<T, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, T> inputConverter(SecurityContext securityContext) {
        return this.notion.getEntityConverter(securityContext);
    }

    @Override
    public T getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return (T)this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public T getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        OneEndpoint<T> endpoint = this.relation.getTarget();
        return (T)endpoint.get(securityContext, (NodeInterface)obj, (Predicate)predicate);
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, T value) throws FrameworkException {
        OneEndpoint<T> endpoint = this.relation.getTarget();
        return endpoint.set(securityContext, (NodeInterface)obj, value);
    }

    @Override
    public Class relatedType() {
        return this.destType;
    }

    @Override
    public Class valueType() {
        return this.relatedType();
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public Property<T> indexed() {
        return this;
    }

    @Override
    public Property<T> passivelyIndexed() {
        return this;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        return null;
    }

    @Override
    public void index(GraphObject entity, Object value) {
    }

    @Override
    public Notion getNotion() {
        return this.notion;
    }

    @Override
    public void addSingleElement(SecurityContext securityContext, GraphObject obj, T t) throws FrameworkException {
        this.setProperty(securityContext, obj, t);
    }

    @Override
    public Class<T> getTargetType() {
        return this.destType;
    }

    @Override
    public SearchAttribute getSearchAttribute(SecurityContext securityContext, Occurrence occur, T searchValue, boolean exactMatch, Query query) {
        Predicate<GraphObject> predicate = query != null ? query.toPredicate() : null;
        SourceSearchAttribute attr = new SourceSearchAttribute(occur);
        LinkedHashSet<GraphObject> intersectionResult = new LinkedHashSet<GraphObject>();
        boolean alreadyAdded = false;
        if (searchValue != null && !StringUtils.isBlank((CharSequence)searchValue.toString())) {
            if (exactMatch) {
                switch (occur) {
                    case REQUIRED: {
                        if (!alreadyAdded) {
                            intersectionResult.addAll(this.getRelatedNodesReverse(securityContext, (NodeInterface)searchValue, this.declaringClass, predicate));
                            alreadyAdded = true;
                            break;
                        }
                        intersectionResult.retainAll(this.getRelatedNodesReverse(securityContext, (NodeInterface)searchValue, this.declaringClass, predicate));
                        break;
                    }
                    case OPTIONAL: {
                        intersectionResult.addAll(this.getRelatedNodesReverse(securityContext, (NodeInterface)searchValue, this.declaringClass, predicate));
                        break;
                    }
                }
            } else {
                intersectionResult.addAll(this.getRelatedNodesReverse(securityContext, (NodeInterface)searchValue, this.declaringClass, predicate));
            }
        } else {
            return new EmptySearchAttribute<Object>(this, null);
        }
        attr.setResult(intersectionResult);
        return attr;
    }

    @Override
    protected <T extends NodeInterface> Set<T> getRelatedNodesReverse(SecurityContext securityContext, NodeInterface obj, Class destinationType, Predicate<GraphObject> predicate) {
        LinkedHashSet<NodeInterface> relatedNodes = new LinkedHashSet<NodeInterface>();
        try {
            Object source = this.relation.getSource().get(securityContext, obj, predicate);
            if (source != null) {
                if (source instanceof Iterable) {
                    Iterable nodes = (Iterable)source;
                    for (NodeInterface n : nodes) {
                        relatedNodes.add(n);
                    }
                } else {
                    relatedNodes.add((NodeInterface)source);
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to fetch related node: {}", (Object)t.getMessage());
        }
        return relatedNodes;
    }

    @Override
    public Relation getRelation() {
        return this.relation;
    }

    @Override
    public boolean doAutocreate() {
        if (this.relation != null) {
            switch (this.relation.getAutocreationFlag()) {
                case 1: 
                case 3: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getAutocreateFlagName() {
        if (this.relation != null) {
            return Relation.CASCADING_DESCRIPTIONS[this.relation.getAutocreationFlag()];
        }
        return Relation.CASCADING_DESCRIPTIONS[0];
    }

    @Override
    public String getDirectionKey() {
        return "out";
    }
}

