/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.search.Occurrence;
import org.structr.api.search.SortType;
import org.structr.api.util.Iterables;
import org.structr.common.NotNullPredicate;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.ManyEndpoint;
import org.structr.core.entity.Relation;
import org.structr.core.entity.Source;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.search.EmptySearchAttribute;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.graph.search.SourceSearchAttribute;
import org.structr.core.notion.Notion;
import org.structr.core.notion.ObjectNotion;
import org.structr.core.property.Property;
import org.structr.core.property.RelationProperty;

public class EndNodes<S extends NodeInterface, T extends NodeInterface>
extends Property<List<T>>
implements RelationProperty<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)EndNodes.class.getName());
    private Relation<S, T, ? extends Source, ManyEndpoint<T>> relation = null;
    private Notion notion = null;
    private Class<T> destType = null;

    public EndNodes(String name, Class<? extends Relation<S, T, ? extends Source, ManyEndpoint<T>>> relationClass) {
        this(name, relationClass, (Notion)new ObjectNotion());
    }

    public EndNodes(String name, Class<? extends Relation<S, T, ? extends Source, ManyEndpoint<T>>> relationClass, Notion notion) {
        super(name);
        try {
            this.relation = relationClass.newInstance();
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        this.notion = notion;
        this.destType = this.relation.getTargetType();
        this.notion.setType(this.destType);
        this.notion.setRelationProperty(this);
        StructrApp.getConfiguration().registerConvertedProperty(this);
    }

    public EndNodes(String name, Relation<S, T, ? extends Source, ManyEndpoint<T>> relation, Notion notion) {
        super(name);
        this.relation = relation;
        this.notion = notion;
        this.destType = relation.getTargetType();
        this.notion.setType(this.destType);
        this.notion.setRelationProperty(this);
        StructrApp.getConfiguration().registerConvertedProperty(this);
    }

    @Override
    public String typeName() {
        return "collection";
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public PropertyConverter<List<T>, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<List<T>, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, List<T>> inputConverter(SecurityContext securityContext) {
        return this.getNotion().getCollectionConverter(securityContext);
    }

    @Override
    public List<T> getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public List<T> getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        ManyEndpoint<T> endpoint = this.relation.getTarget();
        if (predicate != null) {
            return Iterables.toList((Iterable)Iterables.filter(predicate, (Iterable)Iterables.filter((Predicate)new NotNullPredicate(), (Iterable)endpoint.get(securityContext, (NodeInterface)obj, (Predicate)null))));
        }
        return Iterables.toList((Iterable)Iterables.filter((Predicate)new NotNullPredicate(), (Iterable)endpoint.get(securityContext, (NodeInterface)obj, (Predicate)null)));
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, List<T> collection) throws FrameworkException {
        ManyEndpoint<T> endpoint = this.relation.getTarget();
        return endpoint.set(securityContext, (NodeInterface)obj, (Iterable<T>)collection);
    }

    @Override
    public Class relatedType() {
        return this.destType;
    }

    @Override
    public Class valueType() {
        return this.relatedType();
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public Property<List<T>> indexed() {
        return this;
    }

    @Override
    public Property<List<T>> passivelyIndexed() {
        return this;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        return null;
    }

    @Override
    public void index(GraphObject entity, Object value) {
    }

    @Override
    public Notion getNotion() {
        return this.notion;
    }

    @Override
    public void addSingleElement(SecurityContext securityContext, GraphObject obj, T t) throws FrameworkException {
        Object list = this.getProperty(securityContext, obj, false);
        list.add(t);
        this.setProperty(securityContext, obj, (List<T>)list);
    }

    @Override
    public Class<T> getTargetType() {
        return this.destType;
    }

    @Override
    public List<T> convertSearchValue(SecurityContext securityContext, String requestParameter) throws FrameworkException {
        PropertyConverter<?, List<T>> inputConverter = this.inputConverter(securityContext);
        if (inputConverter != null) {
            LinkedList<String> sources = new LinkedList<String>();
            if (requestParameter != null) {
                for (String part : requestParameter.split("[,;]+")) {
                    sources.add(part);
                }
            }
            return inputConverter.convert(sources);
        }
        return null;
    }

    @Override
    public SearchAttribute getSearchAttribute(SecurityContext securityContext, Occurrence occur, List<T> searchValue, boolean exactMatch, Query query) {
        Predicate<GraphObject> predicate = query != null ? query.toPredicate() : null;
        SourceSearchAttribute attr = new SourceSearchAttribute(occur);
        LinkedHashSet<GraphObject> intersectionResult = new LinkedHashSet<GraphObject>();
        boolean alreadyAdded = false;
        if (searchValue != null && !StringUtils.isBlank((CharSequence)searchValue.toString())) {
            if (exactMatch) {
                for (NodeInterface node : searchValue) {
                    switch (occur) {
                        case REQUIRED: {
                            if (!alreadyAdded) {
                                intersectionResult.addAll(this.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                                alreadyAdded = true;
                                break;
                            }
                            intersectionResult.retainAll(this.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                            break;
                        }
                        case OPTIONAL: {
                            intersectionResult.addAll(this.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                            break;
                        }
                    }
                }
            } else {
                for (NodeInterface node : searchValue) {
                    intersectionResult.addAll(this.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                }
            }
        } else {
            return new EmptySearchAttribute<Object>(this, null);
        }
        attr.setResult(intersectionResult);
        return attr;
    }

    @Override
    protected <T extends NodeInterface> Set<T> getRelatedNodesReverse(SecurityContext securityContext, NodeInterface obj, Class destinationType, Predicate<GraphObject> predicate) {
        LinkedHashSet<NodeInterface> relatedNodes = new LinkedHashSet<NodeInterface>();
        try {
            Object source = this.relation.getSource().get(securityContext, obj, predicate);
            if (source != null) {
                if (source instanceof Iterable) {
                    Iterable nodes = (Iterable)source;
                    for (NodeInterface n : nodes) {
                        relatedNodes.add(n);
                    }
                } else {
                    relatedNodes.add((NodeInterface)source);
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to fetch related node: {}", (Object)t.getMessage());
        }
        return relatedNodes;
    }

    @Override
    public Relation getRelation() {
        return this.relation;
    }

    @Override
    public boolean doAutocreate() {
        if (this.relation != null) {
            switch (this.relation.getAutocreationFlag()) {
                case 1: 
                case 3: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getAutocreateFlagName() {
        if (this.relation != null) {
            return Relation.CASCADING_DESCRIPTIONS[this.relation.getAutocreationFlag()];
        }
        return Relation.CASCADING_DESCRIPTIONS[0];
    }

    @Override
    public String getDirectionKey() {
        return "out";
    }
}

