/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.search.Occurrence;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.search.EmptySearchAttribute;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.graph.search.SourceSearchAttribute;
import org.structr.core.notion.Notion;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;

public class EntityNotionProperty<S extends NodeInterface, T>
extends Property<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)EntityNotionProperty.class.getName());
    private Property<S> entityProperty = null;
    private Notion<S, T> notion = null;

    public EntityNotionProperty(String name, Property<S> base, Notion<S, T> notion) {
        super(name);
        this.notion = notion;
        this.entityProperty = base;
        notion.setType(base.relatedType());
    }

    @Override
    public Property<T> indexed() {
        return this;
    }

    @Override
    public Property<T> passivelyIndexed() {
        return this;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        return null;
    }

    @Override
    public String typeName() {
        return "";
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public PropertyConverter<T, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<T, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, T> inputConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public T getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, null);
    }

    @Override
    public T getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        try {
            return this.notion.getAdapterForGetter(securityContext).adapt(this.entityProperty.getProperty(securityContext, obj, applyConverter, predicate));
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to apply notion of type {} to property {}", new Object[]{this.notion.getClass(), this});
            return null;
        }
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, T value) throws FrameworkException {
        if (value != null) {
            return this.entityProperty.setProperty(securityContext, obj, this.notion.getAdapterForSetter(securityContext).adapt(value));
        }
        return this.entityProperty.setProperty(securityContext, obj, null);
    }

    @Override
    public Class relatedType() {
        return this.entityProperty.relatedType();
    }

    @Override
    public Class valueType() {
        return this.relatedType();
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public SearchAttribute getSearchAttribute(SecurityContext securityContext, Occurrence occur, T searchValue, boolean exactMatch, Query query) {
        Predicate<GraphObject> predicate = query != null ? query.toPredicate() : null;
        SourceSearchAttribute attr = new SourceSearchAttribute(occur);
        LinkedHashSet<GraphObject> intersectionResult = new LinkedHashSet<GraphObject>();
        boolean alreadyAdded = false;
        try {
            if (searchValue != null && !StringUtils.isBlank((CharSequence)searchValue.toString())) {
                T transformedValue;
                App app = StructrApp.getInstance(securityContext);
                PropertyKey<T> key = this.notion.getPrimaryPropertyKey();
                PropertyConverter<?, T> inputConverter = key != null ? key.inputConverter(securityContext) : null;
                T t = transformedValue = inputConverter != null ? inputConverter.convert(searchValue) : searchValue;
                if (exactMatch) {
                    Result result = app.nodeQuery(this.entityProperty.relatedType()).and(key, transformedValue).getResult();
                    for (AbstractNode node : result.getResults()) {
                        switch (occur) {
                            case REQUIRED: {
                                if (!alreadyAdded) {
                                    intersectionResult.addAll(this.entityProperty.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                                    alreadyAdded = true;
                                    break;
                                }
                                intersectionResult.retainAll(this.entityProperty.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                                break;
                            }
                            case OPTIONAL: {
                                intersectionResult.addAll(this.entityProperty.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                                break;
                            }
                        }
                    }
                } else {
                    Result result = app.nodeQuery(this.entityProperty.relatedType()).and(key, transformedValue, false).getResult();
                    for (AbstractNode node : result.getResults()) {
                        intersectionResult.addAll(this.entityProperty.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                    }
                }
            } else {
                return new EmptySearchAttribute<Object>(this, null);
            }
            attr.setResult(intersectionResult);
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return attr;
    }

    @Override
    public void index(GraphObject entity, Object value) {
    }

    @Override
    public int getProcessingOrderPosition() {
        return 1000;
    }
}

