/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.ValueToken;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.AbstractPrimitiveProperty;
import org.structr.core.property.PropertyKey;

public class EnumProperty<T extends Enum>
extends AbstractPrimitiveProperty<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)EnumProperty.class.getName());
    private Class<T> enumType = null;

    public EnumProperty(String name, Class<T> enumType) {
        this(name, enumType, null);
    }

    public EnumProperty(String jsonName, String dbName, Class<T> enumType) {
        this(jsonName, dbName, enumType, null);
    }

    public EnumProperty(String name, Class<T> enumType, T defaultValue) {
        this(name, name, enumType, defaultValue);
    }

    public EnumProperty(String jsonName, String dbName, Class<T> enumType, T defaultValue) {
        super(jsonName, dbName, defaultValue);
        this.enumType = enumType;
        this.addEnumValuesToFormat();
    }

    @Override
    public String typeName() {
        return "Enum";
    }

    @Override
    public Class valueType() {
        return this.enumType;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public PropertyConverter<T, String> databaseConverter(SecurityContext securityContext) {
        return this.databaseConverter(securityContext, null);
    }

    @Override
    public PropertyConverter<T, String> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return new DatabaseConverter(securityContext, entity);
    }

    @Override
    public PropertyConverter<String, T> inputConverter(SecurityContext securityContext) {
        return new InputConverter(securityContext);
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        if (value != null && value instanceof String) {
            return value;
        }
        return null;
    }

    public Class<T> getEnumType() {
        return this.enumType;
    }

    @Override
    public PropertyType getDataType() {
        return PropertyType.STRING;
    }

    private void addEnumValuesToFormat() {
        this.format = "";
        for (Enum enumConst : (Enum[])this.enumType.getEnumConstants()) {
            this.format = this.format + enumConst.toString() + ",";
        }
        this.format = this.format.substring(0, this.format.length() - 1);
    }

    protected class InputConverter
    extends PropertyConverter<String, T> {
        public InputConverter(SecurityContext securityContext) {
            super(securityContext, null);
        }

        @Override
        public String revert(T source) throws FrameworkException {
            if (source != null) {
                return ((Enum)source).toString();
            }
            return null;
        }

        @Override
        public T convert(String source) throws FrameworkException {
            if (StringUtils.isNotBlank((String)source)) {
                try {
                    return Enum.valueOf(EnumProperty.this.enumType, source);
                }
                catch (Throwable t) {
                    throw new FrameworkException(422, "Cannot parse input for property " + EnumProperty.this.jsonName(), new ValueToken(EnumProperty.this.declaringClass.getSimpleName(), (PropertyKey)EnumProperty.this, EnumProperty.this.enumType.getEnumConstants()));
                }
            }
            return null;
        }
    }

    protected class DatabaseConverter
    extends PropertyConverter<T, String> {
        public DatabaseConverter(SecurityContext securityContext, GraphObject entity) {
            super(securityContext, entity);
        }

        @Override
        public T revert(String source) throws FrameworkException {
            if (StringUtils.isNotBlank((String)source)) {
                try {
                    return Enum.valueOf(EnumProperty.this.enumType, source);
                }
                catch (Throwable t) {
                    logger.warn("Cannot convert database value '{}' on object {} to enum of type '{}', ignoring.", new Object[]{source, this.currentObject.getUuid(), EnumProperty.this.enumType.getSimpleName()});
                }
            }
            return null;
        }

        @Override
        public String convert(T source) throws FrameworkException {
            if (source != null) {
                return ((Enum)source).toString();
            }
            return null;
        }
    }
}

