/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.search.Occurrence;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.ReadOnlyPropertyToken;
import org.structr.core.GraphObject;
import org.structr.core.PropertyGroup;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.graph.search.PropertySearchAttribute;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.graph.search.SearchAttributeGroup;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;

public class GroupProperty
extends Property<PropertyMap>
implements PropertyGroup<PropertyMap> {
    private static final Logger logger = LoggerFactory.getLogger((String)GroupProperty.class.getName());
    protected Map<String, PropertyKey> propertyKeys = new LinkedHashMap<String, PropertyKey>();
    protected Class<? extends GraphObject> entityClass = null;
    protected Property<Boolean> nullValuesOnlyProperty = null;

    public GroupProperty(String name, Class<? extends GraphObject> entityClass, PropertyKey ... properties) {
        super(name);
        for (PropertyKey key : properties) {
            this.propertyKeys.put(key.jsonName(), key);
            key.dbName(name.concat(".").concat(key.dbName()));
        }
        this.nullValuesOnlyProperty = new BooleanProperty(name.concat(".").concat("nullValuesOnly"));
        this.entityClass = entityClass;
        StructrApp.getConfiguration().registerPropertyGroup(entityClass, this, this);
    }

    public GroupProperty indexed() {
        for (PropertyKey key : this.propertyKeys.values()) {
            key.indexed();
        }
        return (GroupProperty)super.indexed();
    }

    public GroupProperty passivelyIndexed() {
        for (PropertyKey key : this.propertyKeys.values()) {
            key.passivelyIndexed();
        }
        return (GroupProperty)super.passivelyIndexed();
    }

    @Override
    public String typeName() {
        return "Object";
    }

    @Override
    public PropertyConverter<PropertyMap, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<PropertyMap, ?> databaseConverter(SecurityContext securityContext, GraphObject currentObject) {
        return null;
    }

    @Override
    public PropertyConverter<Map<String, Object>, PropertyMap> inputConverter(SecurityContext securityContext) {
        return new InputConverter(securityContext);
    }

    @Override
    public SearchAttribute getSearchAttribute(SecurityContext securityContext, Occurrence occur, PropertyMap searchValues, boolean exactMatch, Query query) {
        SearchAttributeGroup group = new SearchAttributeGroup(occur);
        for (PropertyKey key : this.propertyKeys.values()) {
            Object value = searchValues.get(new GenericProperty(key.jsonName()));
            if (value == null) continue;
            group.add(new PropertySearchAttribute<String>(key, value.toString(), Occurrence.REQUIRED, exactMatch));
        }
        return group;
    }

    public <T> PropertyKey<T> getNestedProperty(String name, Class<T> type) {
        if (!this.propertyKeys.containsKey(name)) {
            throw new IllegalArgumentException("GroupProperty " + this.dbName + " does not contain grouped property " + name + "!");
        }
        return this.propertyKeys.get(name);
    }

    public <T> PropertyKey<T> getDirectAccessGroupProperty(String name, Class<T> type) {
        if (!this.propertyKeys.containsKey(name)) {
            throw new IllegalArgumentException("GroupProperty " + this.dbName + " does not contain grouped property " + name + "!");
        }
        return new GenericProperty(this.propertyKeys.get(name).dbName());
    }

    @Override
    public PropertyMap getGroupedProperties(SecurityContext securityContext, GraphObject source) {
        PropertyMap groupedProperties = new PropertyMap();
        Boolean nullValuesOnly = source.getProperty(this.nullValuesOnlyProperty);
        if (nullValuesOnly != null && nullValuesOnly.booleanValue()) {
            return null;
        }
        for (PropertyKey key : this.propertyKeys.values()) {
            Object value = source.getProperty(key);
            groupedProperties.put(key, value);
            if (value == null) continue;
            nullValuesOnly = false;
        }
        return groupedProperties;
    }

    @Override
    public void setGroupedProperties(SecurityContext securityContext, PropertyMap source, GraphObject destination) throws FrameworkException {
        if (source.containsKey(this.nullValuesOnlyProperty)) {
            throw new FrameworkException(422, "Property " + this.jsonName + " is read-only", new ReadOnlyPropertyToken(destination.getClass().getSimpleName(), this.nullValuesOnlyProperty));
        }
        if (source.isEmpty()) {
            destination.setProperty(this.nullValuesOnlyProperty, true);
            return;
        }
        destination.setProperty(this.nullValuesOnlyProperty, false);
        for (PropertyKey key : this.propertyKeys.values()) {
            Object value = source.get(new GenericProperty(key.jsonName()));
            PropertyConverter converter = key.inputConverter(securityContext);
            if (converter != null) {
                try {
                    Object convertedValue = converter.convert(value);
                    destination.setProperty(key, convertedValue);
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to convert grouped property {} on type {}: {}", new Object[]{key.dbName(), source.getClass().getSimpleName(), fex.getMessage()});
                }
                continue;
            }
            destination.setProperty(key, value);
        }
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        return null;
    }

    @Override
    public PropertyMap getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public PropertyMap getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        return this.getGroupedProperties(securityContext, obj);
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, PropertyMap value) throws FrameworkException {
        this.setGroupedProperties(securityContext, value, obj);
        return null;
    }

    @Override
    public Class relatedType() {
        return null;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public Class valueType() {
        return PropertyMap.class;
    }

    @Override
    public void setDeclaringClass(Class declaringClass) {
        for (PropertyKey key : this.propertyKeys.values()) {
            key.setDeclaringClass(declaringClass);
        }
    }

    @Override
    public void extractSearchableAttribute(SecurityContext securityContext, HttpServletRequest request, boolean exactMatch, Query query) throws FrameworkException {
        for (PropertyKey propertyKey : this.propertyKeys.values()) {
            Property key;
            String searchValue;
            if (!(propertyKey instanceof Property) || (searchValue = request.getParameter((key = (Property)propertyKey).dbName())) == null) continue;
            key.determineSearchType(securityContext, searchValue, exactMatch, query);
        }
    }

    private class InputConverter
    extends PropertyConverter<Map<String, Object>, PropertyMap> {
        public InputConverter(SecurityContext securityContext) {
            super(securityContext, null);
        }

        @Override
        public Map<String, Object> revert(PropertyMap source) throws FrameworkException {
            return PropertyMap.javaTypeToInputType(this.securityContext, GroupProperty.this.entityClass, source);
        }

        @Override
        public PropertyMap convert(Map<String, Object> source) throws FrameworkException {
            return PropertyMap.inputTypeToJavaType(this.securityContext, GroupProperty.this.entityClass, source);
        }
    }
}

