/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.LinkedList;
import java.util.List;
import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.AbstractReadOnlyProperty;
import org.structr.core.property.Property;

public class HyperRelationProperty<S extends AbstractNode, T extends AbstractNode>
extends AbstractReadOnlyProperty<List<T>> {
    Property<List<S>> step1 = null;
    Property<T> step2 = null;

    public HyperRelationProperty(String name, Property<List<S>> step1, Property<T> step2) {
        super(name);
        this.step1 = step1;
        this.step2 = step2;
        StructrApp.getConfiguration().registerConvertedProperty(this);
    }

    @Override
    public List<T> getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public List<T> getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        List<S> connectors = obj.getProperty(this.step1);
        LinkedList<T> endNodes = new LinkedList<T>();
        if (connectors != null) {
            for (AbstractNode node : connectors) {
                endNodes.add(node.getProperty(this.step2));
            }
        }
        return endNodes;
    }

    @Override
    public Class relatedType() {
        return this.step2.relatedType();
    }

    @Override
    public Class valueType() {
        return this.relatedType();
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }
}

