/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.SecurityContext;
import org.structr.common.error.DateFormatToken;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.DateProperty;
import org.structr.schema.parser.DatePropertyParser;

public class ISO8601DateProperty
extends DateProperty {
    public ISO8601DateProperty(String name) {
        super(name);
    }

    @Override
    public PropertyConverter<Date, Long> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return new DatabaseConverter(securityContext, entity);
    }

    @Override
    public PropertyConverter<String, Date> inputConverter(SecurityContext securityContext) {
        return new InputConverter(securityContext);
    }

    private class InputConverter
    extends PropertyConverter<String, Date> {
        public InputConverter(SecurityContext securityContext) {
            super(securityContext, null);
        }

        @Override
        public Date convert(String source) throws FrameworkException {
            if (StringUtils.isNotBlank((CharSequence)source)) {
                Date result = DatePropertyParser.parseISO8601DateString(source);
                if (result != null) {
                    return result;
                }
                throw new FrameworkException(422, "Cannot parse input for property " + ISO8601DateProperty.this.jsonName(), new DateFormatToken(ISO8601DateProperty.this.declaringClass.getSimpleName(), ISO8601DateProperty.this));
            }
            return null;
        }

        @Override
        public String revert(Date source) throws FrameworkException {
            return DatePropertyParser.format(source, null);
        }
    }

    private class DatabaseConverter
    extends PropertyConverter<Date, Long> {
        public DatabaseConverter(SecurityContext securityContext, GraphObject entity) {
            super(securityContext, entity);
        }

        @Override
        public Long convert(Date source) throws FrameworkException {
            if (source != null) {
                return source.getTime();
            }
            return null;
        }

        @Override
        public Date revert(Long source) throws FrameworkException {
            if (source != null) {
                return new Date(source);
            }
            return null;
        }
    }
}

