/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;

public class JoinProperty
extends StringProperty {
    private static final Logger logger = LoggerFactory.getLogger((String)JoinProperty.class.getName());
    private List<PropertyKey> keys = new ArrayList<PropertyKey>();

    public JoinProperty(String name, String separator, PropertyKey ... keys) {
        this(name, name, separator, keys);
    }

    public JoinProperty(String jsonName, String dbName, String messageFormat, PropertyKey ... keys) {
        super(jsonName);
        this.dbName = dbName;
        this.format = messageFormat;
        this.keys.addAll(Arrays.asList(keys));
        this.passivelyIndexed();
    }

    @Override
    public String getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        ArrayList arguments = new ArrayList();
        for (PropertyKey key : this.keys) {
            Object value;
            PropertyConverter inputConverter = key.inputConverter(securityContext);
            if (inputConverter != null) {
                try {
                    value = inputConverter.revert(key.getProperty(securityContext, obj, applyConverter, predicate));
                    if (value == null) continue;
                    arguments.add(value);
                }
                catch (FrameworkException fex) {
                    logger.warn("", (Throwable)fex);
                }
                continue;
            }
            value = key.getProperty(securityContext, obj, applyConverter, predicate);
            if (value == null) continue;
            arguments.add(value);
        }
        try {
            return MessageFormat.format(this.format, arguments.toArray());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, String value) throws FrameworkException {
        MessageFormat formatter = new MessageFormat(this.format, Locale.GERMAN);
        Object[] values = null;
        int len = 0;
        try {
            values = formatter.parse(value);
            len = values.length;
        }
        catch (ParseException pex) {
            throw new FrameworkException(422, pex.getMessage());
        }
        for (int i = 0; i < len; ++i) {
            PropertyKey key = this.keys.get(i);
            PropertyConverter inputConverter = key.inputConverter(securityContext);
            if (inputConverter != null) {
                key.setProperty(securityContext, obj, inputConverter.convert(values[i]));
                continue;
            }
            key.setProperty(securityContext, obj, values[i]);
        }
        return null;
    }
}

