/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.apache.commons.lang3.StringUtils;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.StringProperty;

public class ListArrayProperty
extends StringProperty {
    public static final String SEP = ",";

    public ListArrayProperty(String name) {
        super(name);
    }

    @Override
    public String typeName() {
        return "String";
    }

    @Override
    public PropertyConverter<String, String[]> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return new ListArrayConverter(securityContext);
    }

    @Override
    public PropertyConverter<String[], String> inputConverter(SecurityContext securityContext) {
        return new ArrayListConverter(securityContext);
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        return null;
    }

    public class ArrayListConverter
    extends PropertyConverter<String[], String> {
        public ArrayListConverter(SecurityContext securityContext) {
            super(securityContext, null);
        }

        @Override
        public String[] revert(String source) throws FrameworkException {
            return StringUtils.split((String)source, (String)ListArrayProperty.SEP);
        }

        @Override
        public String convert(String[] source) {
            return StringUtils.join((Object[])source, (String)ListArrayProperty.SEP);
        }
    }

    public class ListArrayConverter
    extends PropertyConverter<String, String[]> {
        public ListArrayConverter(SecurityContext securityContext) {
            super(securityContext, null);
        }

        @Override
        public String revert(String[] source) {
            return StringUtils.join((Object[])source, (String)ListArrayProperty.SEP);
        }

        @Override
        public String[] convert(String source) throws FrameworkException {
            return StringUtils.split((String)source, (String)ListArrayProperty.SEP);
        }
    }
}

