/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.List;
import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.property.AbstractReadOnlyProperty;
import org.structr.core.property.EndNodes;
import org.structr.core.property.Property;

public class LongSumProperty
extends AbstractReadOnlyProperty<Long> {
    private EndNodes<?, ?> collectionProperty = null;
    private Property<Long> valueProperty = null;

    public LongSumProperty(String name, EndNodes<?, ?> collectionProperty, Property<Long> valueProperty, Long defaultValue) {
        super(name, defaultValue);
        this.collectionProperty = collectionProperty;
        this.valueProperty = valueProperty;
        this.defaultValue = defaultValue;
    }

    @Override
    public Class relatedType() {
        return null;
    }

    @Override
    public Class valueType() {
        return Long.class;
    }

    @Override
    public Long getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public Long getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        List collection = (List)obj.getProperty(this.collectionProperty);
        if (collection != null) {
            long sum = 0L;
            for (GraphObject element : collection) {
                Long value = element.getProperty(this.valueProperty);
                if (value == null) continue;
                sum += value.longValue();
            }
            return sum;
        }
        return (Long)this.defaultValue();
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public SortType getSortType() {
        return SortType.Long;
    }
}

