/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.apache.commons.lang3.RandomStringUtils;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.TooShortToken;
import org.structr.core.GraphObject;
import org.structr.core.auth.HashHelper;
import org.structr.core.converter.ValidationInfo;
import org.structr.core.entity.Principal;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;

public class PasswordProperty
extends StringProperty {
    private ValidationInfo validationInfo = null;

    public PasswordProperty(String name) {
        this(name, (ValidationInfo)null);
    }

    public PasswordProperty(String name, ValidationInfo info) {
        super(name);
        this.validationInfo = info;
    }

    @Override
    public void registrationCallback(Class entityType) {
        if (this.validationInfo != null && this.validationInfo.getErrorKey() == null) {
            this.validationInfo.setErrorKey(this);
        }
    }

    @Override
    public String typeName() {
        return "String";
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, String clearTextPassword) throws FrameworkException {
        if (clearTextPassword != null) {
            if (this.validationInfo != null) {
                String errorType = this.validationInfo.getErrorType();
                PropertyKey errorKey = this.validationInfo.getErrorKey();
                int minLength = this.validationInfo.getMinLength();
                if (minLength > 0 && clearTextPassword.length() < minLength) {
                    throw new FrameworkException(422, "Validation of entity with ID " + obj.getUuid() + " failed", new TooShortToken(errorType, (PropertyKey<String>)errorKey, minLength));
                }
            }
            String salt = RandomStringUtils.randomAlphanumeric((int)16);
            obj.setProperty(Principal.salt, salt);
            return super.setProperty(securityContext, obj, HashHelper.getHash(clearTextPassword, salt));
        }
        return super.setProperty(securityContext, obj, null);
    }
}

