/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.api.index.Index;
import org.structr.api.search.Occurrence;
import org.structr.bolt.index.AbstractCypherIndex;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.app.Query;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeService;
import org.structr.core.graph.search.PropertySearchAttribute;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.property.PropertyKey;

public abstract class Property<T>
implements PropertyKey<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)Property.class.getName());
    private static final Pattern rangeQueryPattern = Pattern.compile("\\[(.+) TO (.+)\\]");
    protected Class<? extends GraphObject> declaringClass = null;
    protected T defaultValue = null;
    protected boolean readOnly = false;
    protected boolean systemInternal = false;
    protected boolean writeOnce = false;
    protected boolean unvalidated = false;
    protected boolean indexed = false;
    protected boolean indexedPassively = false;
    protected boolean indexedWhenEmpty = false;
    protected boolean compound = false;
    protected boolean unique = false;
    protected boolean notNull = false;
    protected boolean dynamic = false;
    protected boolean isCMISProperty = false;
    protected String dbName = null;
    protected String jsonName = null;
    protected String format = null;
    protected String readFunction = null;
    protected String writeFunction = null;
    private boolean requiresSynchronization = false;

    protected Property(String name) {
        this(name, name);
    }

    protected Property(String jsonName, String dbName) {
        this(jsonName, dbName, null);
    }

    protected Property(String jsonName, String dbName, T defaultValue) {
        this.defaultValue = defaultValue;
        this.jsonName = jsonName;
        this.dbName = dbName;
    }

    @Override
    public abstract Object fixDatabaseProperty(Object var1);

    public Property<T> unvalidated() {
        this.unvalidated = true;
        return this;
    }

    public Property<T> readOnly() {
        this.readOnly = true;
        return this;
    }

    public Property<T> systemInternal() {
        this.systemInternal = true;
        return this;
    }

    public Property<T> writeOnce() {
        this.writeOnce = true;
        return this;
    }

    public Property<T> unique() {
        this.unique = true;
        this.requiresSynchronization = true;
        return this;
    }

    public Property<T> compound() {
        this.compound = true;
        this.requiresSynchronization = true;
        return this;
    }

    public Property<T> notNull() {
        this.notNull = true;
        return this;
    }

    @Override
    public Property<T> indexed() {
        this.indexed = true;
        return this;
    }

    @Override
    public Property<T> passivelyIndexed() {
        this.indexedPassively = true;
        this.indexed = true;
        return this;
    }

    @Override
    public Property<T> indexedWhenEmpty() {
        this.passivelyIndexed();
        this.indexedWhenEmpty = true;
        return this;
    }

    @Override
    public Property<T> cmis() {
        this.isCMISProperty = true;
        return this;
    }

    @Override
    public boolean requiresSynchronization() {
        return this.requiresSynchronization;
    }

    @Override
    public String getSynchronizationKey() {
        if (this.declaringClass != null) {
            return this.declaringClass.getSimpleName() + "." + this.dbName;
        }
        return "GraphObject." + this.dbName;
    }

    @Override
    public void setDeclaringClass(Class declaringClass) {
        this.declaringClass = declaringClass;
    }

    @Override
    public void registrationCallback(Class type) {
    }

    @Override
    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public String toString() {
        return this.jsonName();
    }

    @Override
    public String dbName() {
        return this.dbName;
    }

    @Override
    public String jsonName() {
        return this.jsonName;
    }

    @Override
    public void dbName(String dbName) {
        this.dbName = dbName;
    }

    @Override
    public void jsonName(String jsonName) {
        this.jsonName = jsonName;
    }

    @Override
    public Property<T> defaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public T defaultValue() {
        return this.defaultValue;
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public Property<T> format(String format) {
        this.format = format;
        return this;
    }

    @Override
    public Property<T> unique(boolean unique) {
        this.unique = unique;
        return this;
    }

    @Override
    public Property<T> notNull(boolean notNull) {
        this.notNull = notNull;
        return this;
    }

    @Override
    public Property<T> dynamic() {
        this.dynamic = true;
        return this;
    }

    @Override
    public String readFunction() {
        return this.readFunction;
    }

    @Override
    public Property<T> readFunction(String readFunction) {
        this.readFunction = readFunction;
        return this;
    }

    @Override
    public String writeFunction() {
        return this.writeFunction;
    }

    @Override
    public Property<T> writeFunction(String writeFunction) {
        this.writeFunction = writeFunction;
        return this;
    }

    public int hashCode() {
        if (this.dbName() != null && this.jsonName() != null) {
            return this.dbName().hashCode() * 31 + this.jsonName().hashCode();
        }
        if (this.dbName() != null) {
            return this.dbName().hashCode();
        }
        if (this.jsonName() != null) {
            return this.jsonName().hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PropertyKey) {
            return o.hashCode() == this.hashCode();
        }
        return false;
    }

    @Override
    public boolean isUnvalidated() {
        return this.unvalidated;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isSystemInternal() {
        return this.systemInternal;
    }

    @Override
    public boolean isWriteOnce() {
        return this.writeOnce;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public boolean isPassivelyIndexed() {
        return this.indexedPassively;
    }

    @Override
    public boolean isIndexedWhenEmpty() {
        return this.indexedWhenEmpty;
    }

    @Override
    public boolean isCompound() {
        return this.compound;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public void index(GraphObject entity, Object value) {
        if (entity instanceof AbstractNode) {
            NodeService nodeService = Services.getInstance().getService(NodeService.class);
            AbstractNode node = (AbstractNode)entity;
            Node dbNode = node.getNode();
            Index<Node> index = nodeService.getNodeIndex();
            if (index != null) {
                try {
                    index.remove((Object)dbNode, this.dbName);
                    if (value != null || this.isIndexedWhenEmpty()) {
                        index.add((Object)dbNode, this.dbName, value, this.valueType());
                    }
                }
                catch (Throwable t) {
                    logger.info("Unable to index property with dbName {} and value {} of type {} on {}: {}", new Object[]{this.dbName, value, this.getClass().getSimpleName(), entity, t});
                    logger.warn("", t);
                }
            }
        } else if (entity instanceof AbstractRelationship) {
            NodeService nodeService = Services.getInstance().getService(NodeService.class);
            AbstractRelationship rel = (AbstractRelationship)entity;
            Relationship dbRel = rel.getRelationship();
            Index<Relationship> index = nodeService.getRelationshipIndex();
            if (index != null) {
                try {
                    index.remove((Object)dbRel, this.dbName);
                    if (value != null || this.isIndexedWhenEmpty()) {
                        index.add((Object)dbRel, this.dbName, value, this.valueType());
                    }
                }
                catch (Throwable t) {
                    logger.info("Unable to index property with dbName {} and value {} of type {} on {}: {}", new Object[]{this.dbName, value, this.getClass().getSimpleName(), entity, t});
                }
            }
        }
    }

    @Override
    public boolean indexable(Object value) {
        Class valueType;
        if (value != null && (valueType = this.valueType()) != null) {
            if (AbstractCypherIndex.INDEXABLE.contains(valueType)) {
                return true;
            }
            if (valueType.equals(Date.class)) {
                return true;
            }
            if (valueType.isEnum()) {
                return true;
            }
            if (valueType.isArray()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public SearchAttribute getSearchAttribute(SecurityContext securityContext, Occurrence occur, T searchValue, boolean exactMatch, Query query) {
        return new PropertySearchAttribute<T>(this, searchValue, occur, exactMatch);
    }

    @Override
    public void extractSearchableAttribute(SecurityContext securityContext, HttpServletRequest request, boolean exactMatch, Query query) throws FrameworkException {
        String[] searchValues = request.getParameterValues(this.jsonName());
        if (searchValues != null) {
            for (String searchValue : searchValues) {
                this.determineSearchType(securityContext, searchValue, exactMatch, query);
            }
        }
    }

    @Override
    public T convertSearchValue(SecurityContext securityContext, String requestParameter) throws FrameworkException {
        PropertyConverter inputConverter = this.inputConverter(securityContext);
        String convertedSearchValue = requestParameter;
        if (inputConverter != null) {
            convertedSearchValue = inputConverter.convert(convertedSearchValue);
        }
        return (T)convertedSearchValue;
    }

    @Override
    public int getProcessingOrderPosition() {
        return 0;
    }

    @Override
    public PropertyType getDataType() {
        return null;
    }

    @Override
    public boolean isCMISProperty() {
        return this.isCMISProperty;
    }

    @Override
    public int compareTo(PropertyKey other) {
        return this.dbName().compareTo(other.dbName());
    }

    protected boolean multiValueSplitAllowed() {
        return true;
    }

    protected final String removeQuotes(String searchValue) {
        String resultStr = searchValue;
        if (resultStr.contains("\"")) {
            resultStr = resultStr.replaceAll("[\"]+", "");
        }
        if (resultStr.contains("'")) {
            resultStr = resultStr.replaceAll("[']+", "");
        }
        return resultStr;
    }

    protected void determineSearchType(SecurityContext securityContext, String requestParameter, boolean exactMatch, Query query) throws FrameworkException {
        if (StringUtils.startsWith((CharSequence)requestParameter, (CharSequence)"[") && StringUtils.endsWith((CharSequence)requestParameter, (CharSequence)"]")) {
            Matcher matcher = rangeQueryPattern.matcher(requestParameter);
            if (matcher.matches()) {
                if (matcher.groupCount() == 2) {
                    String rangeStart = matcher.group(1);
                    String rangeEnd = matcher.group(2);
                    PropertyConverter inputConverter = this.inputConverter(securityContext);
                    String rangeStartConverted = rangeStart;
                    String rangeEndConverted = rangeEnd;
                    if (inputConverter != null) {
                        rangeStartConverted = inputConverter.convert(rangeStartConverted);
                        rangeEndConverted = inputConverter.convert(rangeEndConverted);
                    }
                    query.andRange(this, rangeStartConverted, rangeEndConverted);
                    return;
                }
                logger.warn("Unable to determine range query bounds for {}", (Object)requestParameter);
            } else {
                if ("[]".equals(requestParameter)) {
                    if (this.isIndexedWhenEmpty()) {
                        query.notBlank(this);
                        return;
                    }
                    throw new FrameworkException(400, "PropertyKey " + this.jsonName() + " must be indexedWhenEmpty() to be used in not-blank search query.");
                }
                throw new FrameworkException(422, "Invalid range pattern.");
            }
        }
        if (requestParameter.contains(",") && requestParameter.contains(";")) {
            throw new FrameworkException(422, "Mixing of AND and OR not allowed in request parameters");
        }
        if (requestParameter.contains(";")) {
            if (this.multiValueSplitAllowed()) {
                query.and();
                for (String part : requestParameter.split("[;]+")) {
                    query.or(this, this.convertSearchValue(securityContext, part), exactMatch);
                }
                query.parent();
            } else {
                query.or(this, this.convertSearchValue(securityContext, requestParameter), exactMatch);
            }
        } else {
            query.and(this, this.convertSearchValue(securityContext, requestParameter), exactMatch);
        }
    }

    protected <T extends NodeInterface> Set<T> getRelatedNodesReverse(SecurityContext securityContext, NodeInterface obj, Class destinationType, Predicate<GraphObject> predicate) {
        return Collections.emptySet();
    }
}

