/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.CreationContainer;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.PropertyKey;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.SchemaHelper;

public class PropertyMap {
    private static final Logger logger = LoggerFactory.getLogger((String)PropertyMap.class.getName());
    private static final Map<String, String> CMIS_PROPERTY_MAPPING = new LinkedHashMap<String, String>();
    protected Map<PropertyKey, Object> properties = new LinkedHashMap<PropertyKey, Object>();

    public PropertyMap() {
    }

    public PropertyMap(PropertyMap source) {
        this.putAll(source);
    }

    public <T> PropertyMap(PropertyKey<T> key, T value) {
        this.properties.put(key, value);
    }

    public String toString() {
        return this.properties.toString();
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public <T> boolean containsKey(PropertyKey<T> key) {
        return this.properties.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    public <T> T get(PropertyKey<T> key) {
        return (T)this.properties.get(key);
    }

    public <T> T put(PropertyKey<T> key, T value) {
        return (T)this.properties.put(key, value);
    }

    public final void putAll(PropertyMap source) {
        if (source != null) {
            for (Map.Entry<PropertyKey, Object> entry : source.entrySet()) {
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public <T> T remove(PropertyKey<T> key) {
        return (T)this.properties.remove(key);
    }

    public void clear() {
        this.properties.clear();
    }

    public Set<PropertyKey> keySet() {
        return this.properties.keySet();
    }

    public Collection<Object> values() {
        return this.properties.values();
    }

    public Set<Map.Entry<PropertyKey, Object>> entrySet() {
        return this.properties.entrySet();
    }

    public Map<PropertyKey, Object> getRawMap() {
        return this.properties;
    }

    public int contentHashCode(Set<PropertyKey> comparableKeys, boolean includeSystemProperties) {
        TreeMap<PropertyKey, Object> sortedMap = new TreeMap<PropertyKey, Object>(new PropertyKeyComparator());
        int hashCode = 42;
        sortedMap.putAll(this.properties);
        if (comparableKeys == null) {
            for (Map.Entry entry : sortedMap.entrySet()) {
                if (!includeSystemProperties && ((PropertyKey)entry.getKey()).isUnvalidated()) continue;
                hashCode ^= entry.hashCode();
            }
        } else {
            for (Map.Entry entry : sortedMap.entrySet()) {
                PropertyKey key = (PropertyKey)entry.getKey();
                if (!comparableKeys.contains(key) || !includeSystemProperties && key.isUnvalidated()) continue;
                hashCode ^= entry.hashCode();
            }
        }
        return hashCode;
    }

    public static PropertyMap javaTypeToDatabaseType(SecurityContext securityContext, GraphObject wrapped, Map<String, Object> source) throws FrameworkException {
        PropertyMap resultMap = new PropertyMap();
        GraphObject entity = PropertyMap.unwrap(wrapped);
        if (source != null) {
            for (Map.Entry<String, Object> entry : source.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key == null) continue;
                PropertyKey propertyKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(entity.getClass(), key);
                PropertyConverter converter = propertyKey.databaseConverter(securityContext, entity);
                if (converter != null) {
                    try {
                        Object propertyValue = converter.convert(value);
                        resultMap.put(propertyKey, propertyValue);
                        continue;
                    }
                    catch (ClassCastException cce) {
                        throw new FrameworkException(422, "Invalid JSON input for key " + propertyKey.jsonName() + ", expected a JSON " + propertyKey.typeName() + ".");
                    }
                }
                resultMap.put(propertyKey, value);
            }
        }
        return resultMap;
    }

    public static PropertyMap databaseTypeToJavaType(SecurityContext securityContext, GraphObject wrapped, Map<String, Object> source) throws FrameworkException {
        PropertyMap resultMap = new PropertyMap();
        GraphObject entity = PropertyMap.unwrap(wrapped);
        Class<?> entityType = entity.getClass();
        if (source != null) {
            for (Map.Entry<String, Object> entry : source.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key == null) continue;
                PropertyKey propertyKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(entityType, key);
                PropertyConverter<Object, ?> converter = propertyKey.databaseConverter(securityContext, entity);
                if (converter != null) {
                    try {
                        Object propertyValue = converter.revert(value);
                        resultMap.put(propertyKey, propertyValue);
                        continue;
                    }
                    catch (ClassCastException cce) {
                        throw new FrameworkException(422, "Invalid JSON input for key " + propertyKey.jsonName() + ", expected a JSON " + propertyKey.typeName() + ".");
                    }
                }
                resultMap.put(propertyKey, value);
            }
        }
        return resultMap;
    }

    public static PropertyMap databaseTypeToJavaType(SecurityContext securityContext, Class<? extends GraphObject> entityType, Map<String, Object> source) throws FrameworkException {
        PropertyMap resultMap = new PropertyMap();
        if (source != null) {
            for (Map.Entry<String, Object> entry : source.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key == null) continue;
                PropertyKey propertyKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(entityType, key);
                PropertyConverter<Object, ?> converter = propertyKey.databaseConverter(securityContext);
                if (converter != null) {
                    try {
                        Object propertyValue = converter.revert(value);
                        resultMap.put(propertyKey, propertyValue);
                        continue;
                    }
                    catch (ClassCastException cce) {
                        throw new FrameworkException(422, "Invalid JSON input for key " + propertyKey.jsonName() + ", expected a JSON " + propertyKey.typeName() + ".");
                    }
                }
                resultMap.put(propertyKey, value);
            }
        }
        return resultMap;
    }

    public static PropertyMap inputTypeToJavaType(SecurityContext securityContext, Map<String, Object> source) throws FrameworkException {
        if (source != null) {
            Object typeName = source.get(AbstractNode.type.jsonName());
            if (typeName != null) {
                Class type = SchemaHelper.getEntityClassForRawType(typeName.toString());
                if (type != null) {
                    return PropertyMap.inputTypeToJavaType(securityContext, type, source);
                }
                logger.warn("No entity type found for raw type {}", typeName);
            } else {
                logger.warn("No entity type found in source map: {}", source);
            }
        }
        return PropertyMap.fallbackPropertyMap(source);
    }

    public static PropertyMap inputTypeToJavaType(SecurityContext securityContext, Class<? extends GraphObject> entity, Map<String, Object> source) throws FrameworkException {
        PropertyMap resultMap = new PropertyMap();
        if (source != null) {
            for (Map.Entry<String, Object> entry : source.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key == null) continue;
                PropertyKey propertyKey = StructrApp.getConfiguration().getPropertyKeyForJSONName(entity, key);
                PropertyConverter converter = propertyKey.inputConverter(securityContext);
                if (converter != null) {
                    try {
                        converter.setContext(source);
                        Object propertyValue = converter.convert(value);
                        resultMap.put(propertyKey, propertyValue);
                        continue;
                    }
                    catch (ClassCastException cce) {
                        logger.warn("", (Throwable)cce);
                        throw new FrameworkException(422, "Invalid JSON input for key " + propertyKey.jsonName() + ", expected a JSON " + propertyKey.typeName() + ".");
                    }
                }
                resultMap.put(propertyKey, value);
            }
        }
        return resultMap;
    }

    public static Map<String, Object> javaTypeToDatabaseType(SecurityContext securityContext, Class<? extends GraphObject> entity, PropertyMap properties) throws FrameworkException {
        LinkedHashMap<String, Object> databaseTypedProperties = new LinkedHashMap<String, Object>();
        for (Map.Entry<PropertyKey, Object> entry : properties.entrySet()) {
            PropertyKey propertyKey = entry.getKey();
            PropertyConverter converter = propertyKey.databaseConverter(securityContext);
            if (converter != null) {
                try {
                    Object propertyValue = converter.convert(entry.getValue());
                    databaseTypedProperties.put(propertyKey.jsonName(), propertyValue);
                    continue;
                }
                catch (ClassCastException cce) {
                    throw new FrameworkException(422, "Invalid JSON input for key " + propertyKey.jsonName() + ", expected a JSON " + propertyKey.typeName() + ".");
                }
            }
            databaseTypedProperties.put(propertyKey.jsonName(), entry.getValue());
        }
        return databaseTypedProperties;
    }

    public static Map<String, Object> javaTypeToInputType(SecurityContext securityContext, Class<? extends GraphObject> entity, PropertyMap properties) throws FrameworkException {
        LinkedHashMap<String, Object> inputTypedProperties = new LinkedHashMap<String, Object>();
        for (Map.Entry<PropertyKey, Object> entry : properties.entrySet()) {
            PropertyKey propertyKey = entry.getKey();
            PropertyConverter<?, Object> converter = propertyKey.inputConverter(securityContext);
            if (converter != null) {
                try {
                    Object propertyValue = converter.revert(entry.getValue());
                    inputTypedProperties.put(propertyKey.jsonName(), propertyValue);
                    continue;
                }
                catch (ClassCastException cce) {
                    throw new FrameworkException(422, "Invalid JSON input for key " + propertyKey.jsonName() + ", expected a JSON " + propertyKey.typeName() + ".");
                }
            }
            inputTypedProperties.put(propertyKey.jsonName(), entry.getValue());
        }
        return inputTypedProperties;
    }

    public static PropertyMap cmisTypeToJavaType(SecurityContext securityContext, Class type, Properties properties) throws FrameworkException {
        Map map = properties.getProperties();
        ConfigurationProvider config = StructrApp.getConfiguration();
        PropertyMap propertyMap = new PropertyMap();
        for (Map.Entry entry : map.entrySet()) {
            PropertyKey propertyKey;
            PropertyData propertyValue = (PropertyData)entry.getValue();
            Object value = propertyValue.getFirstValue();
            String key = (String)entry.getKey();
            if (CMIS_PROPERTY_MAPPING.containsKey(key)) {
                key = CMIS_PROPERTY_MAPPING.get(key);
            }
            if ((propertyKey = config.getPropertyKeyForJSONName(type, key, false)) != null) {
                PropertyConverter converter = propertyKey.inputConverter(securityContext);
                if (converter != null) {
                    value = converter.convert(value);
                }
                propertyMap.put(propertyKey, value);
                continue;
            }
            throw new FrameworkException(500, "Invalid property key " + key + " for type " + type.getSimpleName() + " provided.");
        }
        return propertyMap;
    }

    private static PropertyMap fallbackPropertyMap(Map<String, Object> source) {
        PropertyMap map = new PropertyMap();
        logger.error("Using GenericProperty for input {}", source);
        if (source != null) {
            for (Map.Entry<String, Object> entry : source.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                map.put(new GenericProperty(key), value);
            }
        }
        return map;
    }

    public static GraphObject unwrap(GraphObject source) {
        if (source instanceof CreationContainer) {
            CreationContainer container = (CreationContainer)source;
            return container.getWrappedObject();
        }
        return source;
    }

    static {
        CMIS_PROPERTY_MAPPING.put("cmis:objectId", "id");
        CMIS_PROPERTY_MAPPING.put("cmis:name", "name");
        CMIS_PROPERTY_MAPPING.put("cmis:objectTypeId", "type");
    }

    private static class PropertyKeyComparator
    implements Comparator<PropertyKey> {
        private PropertyKeyComparator() {
        }

        @Override
        public int compare(PropertyKey o1, PropertyKey o2) {
            return o1.jsonName().compareTo(o2.jsonName());
        }
    }
}

