/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.rest;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.core.IJsonInput;
import org.structr.core.JsonInput;
import org.structr.core.JsonSingleInput;

public class JsonInputGSONAdapter
implements InstanceCreator<IJsonInput>,
JsonSerializer<IJsonInput>,
JsonDeserializer<IJsonInput> {
    private static final Logger logger = LoggerFactory.getLogger((String)JsonInputGSONAdapter.class.getName());

    public IJsonInput createInstance(Type type) {
        try {
            return (IJsonInput)type.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }

    public JsonElement serialize(IJsonInput src, Type typeOfSrc, JsonSerializationContext context) {
        return null;
    }

    public IJsonInput deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonSingleInput jsonInput = null;
        JsonInput wrapper = null;
        if (json.isJsonObject()) {
            jsonInput = new JsonSingleInput();
            wrapper = JsonInputGSONAdapter.deserialize(json, context);
            jsonInput.add(wrapper);
        } else if (json.isJsonArray()) {
            jsonInput = new JsonSingleInput();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement elem : array) {
                wrapper = JsonInputGSONAdapter.deserialize(elem, context);
                jsonInput.add(wrapper);
            }
        } else {
            throw new JsonSyntaxException("Invalid JSON, expecting object or array");
        }
        return jsonInput;
    }

    public static JsonInput deserialize(JsonElement json, JsonDeserializationContext context) throws JsonParseException {
        JsonInput wrapper = new JsonInput();
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            for (Map.Entry entry : obj.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement elem = (JsonElement)entry.getValue();
                if (elem.isJsonNull()) {
                    wrapper.add(key, null);
                    continue;
                }
                if (elem.isJsonObject()) {
                    wrapper.add(key, JsonInputGSONAdapter.deserialize(elem, context));
                    continue;
                }
                if (elem.isJsonArray()) {
                    JsonArray array = elem.getAsJsonArray();
                    LinkedList<Object> list = new LinkedList<Object>();
                    for (JsonElement element : array) {
                        if (element.isJsonPrimitive()) {
                            list.add(JsonInputGSONAdapter.fromPrimitive(element.getAsJsonPrimitive()));
                            continue;
                        }
                        if (!element.isJsonObject()) continue;
                        list.add(JsonInputGSONAdapter.deserialize(element, context));
                    }
                    wrapper.add(key, list);
                    continue;
                }
                if (!elem.isJsonPrimitive()) continue;
                wrapper.add(key, JsonInputGSONAdapter.fromPrimitive(elem.getAsJsonPrimitive()));
            }
        } else if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            for (JsonElement elem : array) {
                if (elem.isJsonPrimitive()) {
                    wrapper.add(elem.toString(), JsonInputGSONAdapter.fromPrimitive(elem.getAsJsonPrimitive()));
                    continue;
                }
                if (elem.isJsonObject()) {
                    wrapper.add(elem.toString(), JsonInputGSONAdapter.deserialize(elem, context));
                    continue;
                }
                if (!elem.isJsonArray()) continue;
                wrapper.add(elem.toString(), JsonInputGSONAdapter.deserialize(elem, context));
            }
        } else {
            throw new JsonSyntaxException("Invalid JSON, expecting object or array");
        }
        return wrapper;
    }

    public static Object fromPrimitive(JsonPrimitive p) {
        if (p.isNumber()) {
            Number number = p.getAsNumber();
            if (p.getAsString().contains(".")) {
                return number.doubleValue();
            }
            return number.longValue();
        }
        if (p.isBoolean()) {
            return p.getAsBoolean();
        }
        return p.getAsString();
    }
}

