/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.script;

import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.renjin.script.RenjinScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.entity.AbstractNode;
import org.structr.core.function.Functions;
import org.structr.core.property.DateProperty;
import org.structr.core.script.StructrScriptBindings;
import org.structr.core.script.StructrScriptable;
import org.structr.schema.action.ActionContext;
import org.structr.schema.parser.DatePropertyParser;

public class Scripting {
    private static final Logger logger = LoggerFactory.getLogger((String)Scripting.class.getName());
    private static final Pattern ScriptEngineExpression = Pattern.compile("^\\$\\{(\\w+)\\{(.*)\\}\\}$", 32);
    private static final Map<String, Script> compiledScripts = Collections.synchronizedMap(new LRUMap(10000));

    public static String replaceVariables(ActionContext actionContext, GraphObject entity, Object rawValue) throws FrameworkException {
        String value;
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof String) {
            value = (String)rawValue;
            if (!actionContext.returnRawValue()) {
                LinkedList<Tuple> replacements = new LinkedList<Tuple>();
                for (String expression : Scripting.extractScripts(value)) {
                    try {
                        String partValue;
                        Object extractedValue = Scripting.evaluate(actionContext, entity, expression, "script source");
                        String string = partValue = extractedValue != null ? Scripting.formatToDefaultDateOrString(extractedValue) : "";
                        if (partValue != null) {
                            replacements.add(new Tuple(expression, partValue));
                            continue;
                        }
                        if (value.equals(expression)) continue;
                        replacements.add(new Tuple(expression, ""));
                    }
                    catch (UnlicensedException ex) {
                        ex.log(logger);
                    }
                }
                for (Tuple tuple : replacements) {
                    value = StringUtils.replaceOnce((String)value, (String)tuple.key, (String)tuple.value);
                }
            }
        } else {
            value = rawValue instanceof Boolean ? Boolean.toString((Boolean)rawValue) : rawValue.toString();
        }
        if ("___NULL___".equals(value)) {
            return null;
        }
        value = StringUtils.replaceAll((String)value, (String)"___NULL___", (String)"");
        return value;
    }

    public static Object evaluate(ActionContext actionContext, GraphObject entity, String expression, String methodName) throws FrameworkException, UnlicensedException {
        Matcher matcher;
        boolean isJavascript = expression.startsWith("${{") && expression.endsWith("}}");
        int prefixOffset = isJavascript ? 1 : 0;
        String source = expression.substring(2 + prefixOffset, expression.length() - (1 + prefixOffset));
        String engine = "";
        boolean isScriptEngine = false;
        if (!isJavascript && (matcher = ScriptEngineExpression.matcher(expression)).matches()) {
            engine = matcher.group(1);
            source = matcher.group(2);
            logger.info("Scripting engine {} requested.", (Object)engine);
            isJavascript = StringUtils.isBlank((CharSequence)engine) || "JavaScript".equals(engine);
            isScriptEngine = !isJavascript && StringUtils.isNotBlank((CharSequence)engine);
        }
        actionContext.setJavaScriptContext(isJavascript);
        if (isScriptEngine) {
            return Scripting.evaluateScript(actionContext, entity, engine, source);
        }
        if (isJavascript) {
            return Scripting.evaluateJavascript(actionContext, entity, source, methodName);
        }
        Object extractedValue = Functions.evaluate(actionContext, entity, source);
        String value = extractedValue != null ? extractedValue.toString() : "";
        String output = actionContext.getOutput();
        if (StringUtils.isEmpty((CharSequence)value) && output != null && !output.isEmpty()) {
            extractedValue = output;
        }
        return extractedValue;
    }

    private static Object evaluateScript(ActionContext actionContext, GraphObject entity, String engineName, String script) throws FrameworkException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(engineName);
        if (engine == null) {
            throw new RuntimeException(engineName + " script engine could not be initialized. Check class path.");
        }
        ScriptContext scriptContext = engine.getContext();
        StructrScriptBindings bindings = new StructrScriptBindings(actionContext, entity);
        if (!(engine instanceof RenjinScriptEngine)) {
            scriptContext.setBindings(bindings, 200);
        }
        StringWriter output = new StringWriter();
        scriptContext.setWriter(output);
        try {
            engine.eval(script);
            String extractedValue = output.toString();
            return extractedValue;
        }
        catch (ScriptException e) {
            logger.error("Error while processing {} script: {}", new Object[]{engineName, script, e});
            return null;
        }
    }

    private static Object evaluateJavascript(ActionContext actionContext, GraphObject entity, String script, String methodName) throws FrameworkException {
        String entityName;
        String string = entityName = entity != null ? (String)entity.getProperty(AbstractNode.name) : null;
        String entityDescription = entity != null ? (StringUtils.isNotBlank((CharSequence)entityName) ? "\"" + entityName + "\":" : "") + entity.getUuid() : "anonymous";
        Context scriptingContext = Scripting.setupJavascriptContext();
        try {
            scriptingContext.setLanguageVersion(120);
            scriptingContext.setOptimizationLevel(9);
            scriptingContext.setInstructionObserverThreshold(0);
            scriptingContext.setGenerateObserverCount(false);
            scriptingContext.setGeneratingDebug(true);
            ScriptableObject scope = scriptingContext.initStandardObjects();
            StructrScriptable scriptable = new StructrScriptable(actionContext, entity, scriptingContext);
            scriptable.setParentScope((Scriptable)scope);
            scope.put("Structr", (Scriptable)scope, (Object)scriptable);
            actionContext.clear();
            String sourceLocation = methodName + " [" + entityDescription + "], line ";
            String embeddedSourceCode = Scripting.embedInFunction(actionContext, script);
            Script compiledScript = Scripting.compileOrGetCached(scriptingContext, embeddedSourceCode, sourceLocation, 1);
            Object extractedValue = compiledScript.exec(scriptingContext, (Scriptable)scope);
            if (scriptable.hasException()) {
                throw scriptable.getException();
            }
            String output = actionContext.getOutput();
            if (output != null && !output.isEmpty()) {
                extractedValue = output;
            }
            if (extractedValue == null || extractedValue == Undefined.instance) {
                extractedValue = scriptable.unwrap(scope.get("_structrMainResult", (Scriptable)scope));
            }
            if (extractedValue == null || extractedValue == Undefined.instance) {
                extractedValue = "";
            }
            Object object = extractedValue;
            return object;
        }
        catch (FrameworkException fex) {
            throw fex;
        }
        catch (Throwable t) {
            logger.warn("", t);
            throw new FrameworkException(422, t.getMessage());
        }
        finally {
            Scripting.destroyJavascriptContext();
        }
    }

    public static Context setupJavascriptContext() {
        Context scriptingContext = new ContextFactory().enterContext();
        scriptingContext.setLanguageVersion(120);
        scriptingContext.setOptimizationLevel(9);
        scriptingContext.setInstructionObserverThreshold(0);
        scriptingContext.setGenerateObserverCount(false);
        return scriptingContext;
    }

    public static void destroyJavascriptContext() {
        Context.exit();
    }

    private static String embedInFunction(ActionContext actionContext, String source) {
        StringBuilder buf = new StringBuilder();
        buf.append("function main() { ");
        buf.append(source);
        buf.append("\n}\n");
        buf.append("\n\nvar _structrMainResult = main();");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Script compileOrGetCached(Context context, String source, String sourceName, int lineNo) {
        Map<String, Script> map = compiledScripts;
        synchronized (map) {
            Script script = compiledScripts.get(source);
            if (script == null) {
                script = context.compileString(source, sourceName, lineNo, null);
                compiledScripts.put(source, script);
            }
            return script;
        }
    }

    public static List<String> extractScripts(String source) {
        LinkedList<String> expressions = new LinkedList<String>();
        int length = source.length();
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        boolean inTemplate = false;
        boolean hasBackslash = false;
        boolean hasDollar = false;
        int level = 0;
        int start = 0;
        int end = 0;
        block8: for (int i = 0; i < length; ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '\\': {
                    hasBackslash = true;
                    continue block8;
                }
                case '\'': {
                    if (inTemplate && !inDoubleQuotes && !hasBackslash) {
                        inSingleQuotes = !inSingleQuotes;
                    }
                    hasDollar = false;
                    hasBackslash = false;
                    continue block8;
                }
                case '\"': {
                    if (inTemplate && !inSingleQuotes && !hasBackslash) {
                        inDoubleQuotes = !inDoubleQuotes;
                    }
                    hasDollar = false;
                    hasBackslash = false;
                    continue block8;
                }
                case '$': {
                    hasDollar = true;
                    hasBackslash = false;
                    continue block8;
                }
                case '{': {
                    if (!inTemplate && hasDollar) {
                        inTemplate = true;
                        start = i - 1;
                    } else if (inTemplate && !inSingleQuotes && !inDoubleQuotes) {
                        ++level;
                    }
                    hasDollar = false;
                    hasBackslash = false;
                    continue block8;
                }
                case '}': {
                    if (!inSingleQuotes && !inDoubleQuotes && inTemplate && level-- == 0) {
                        inTemplate = false;
                        end = i + 1;
                        expressions.add(source.substring(start, end));
                        level = 0;
                    }
                    hasDollar = false;
                    hasBackslash = false;
                    continue block8;
                }
                default: {
                    hasDollar = false;
                    hasBackslash = false;
                }
            }
        }
        return expressions;
    }

    public static String formatToDefaultDateOrString(Object value) {
        if (value instanceof Date) {
            return DatePropertyParser.format((Date)value, DateProperty.getDefaultFormat());
        }
        return value.toString();
    }

    private static class Tuple {
        public String key = null;
        public String value = null;

        public Tuple(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

