/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.script;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.structr.core.script.StructrScriptEngine;

public class StructrScriptEngineFactory
implements ScriptEngineFactory {
    private static final Map<String, Object> SCRIPT_ENGINE_PARAMETERS = new HashMap<String, Object>();
    private static final String SCRIPT_ENGINE_NAME = "structr";
    private static final String SCRIPT_ENGINE_VERSION = "1.1";
    private static final List<String> SCRIPT_ENGINE_NAMES = new LinkedList<String>(Arrays.asList("structr"));
    private static final String SCRIPT_LANGUAGE_NAME = "StructrScript";

    @Override
    public String getEngineName() {
        return SCRIPT_ENGINE_NAME;
    }

    @Override
    public String getEngineVersion() {
        return SCRIPT_ENGINE_VERSION;
    }

    @Override
    public List<String> getExtensions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> getMimeTypes() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> getNames() {
        return SCRIPT_ENGINE_NAMES;
    }

    @Override
    public String getLanguageName() {
        return SCRIPT_LANGUAGE_NAME;
    }

    @Override
    public String getLanguageVersion() {
        return SCRIPT_ENGINE_VERSION;
    }

    @Override
    public Object getParameter(String key) {
        return SCRIPT_ENGINE_PARAMETERS.get(key);
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder buf = new StringBuilder();
        buf.append(m);
        buf.append("(");
        buf.append(obj);
        for (String arg : args) {
            buf.append(", ");
            buf.append(arg);
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder buf = new StringBuilder("('");
        buf.append(this.toString());
        buf.append("')");
        return buf.toString();
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder buf = new StringBuilder("${(");
        int length = statements.length;
        for (int i = 0; i < length; ++i) {
            buf.append("(");
            buf.append(statements[i]);
            buf.append(")");
            if (i >= length) continue;
            buf.append(",");
        }
        buf.append(")}");
        return buf.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new StructrScriptEngine(this);
    }

    static {
        SCRIPT_ENGINE_PARAMETERS.put("javax.script.engine", SCRIPT_ENGINE_NAME);
        SCRIPT_ENGINE_PARAMETERS.put("javax.script.engine_version", SCRIPT_ENGINE_VERSION);
        SCRIPT_ENGINE_PARAMETERS.put("javax.script.filename", Collections.EMPTY_LIST);
        SCRIPT_ENGINE_PARAMETERS.put("javax.script.language", SCRIPT_LANGUAGE_NAME);
        SCRIPT_ENGINE_PARAMETERS.put("javax.script.language_version", SCRIPT_ENGINE_VERSION);
        SCRIPT_ENGINE_PARAMETERS.put("javax.script.name", SCRIPT_ENGINE_NAME);
    }
}

