/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cron;

import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.agent.Task;
import org.structr.api.config.Settings;
import org.structr.api.service.Command;
import org.structr.api.service.RunnableService;
import org.structr.api.service.StructrServices;
import org.structr.core.Services;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.cron.CronEntry;
import org.structr.schema.action.Actions;

public class CronService
extends Thread
implements RunnableService {
    private static final Logger logger = LoggerFactory.getLogger((String)CronService.class.getName());
    public static final String EXPRESSION_SUFFIX = "cronExpression";
    public static final TimeUnit GRANULARITY_UNIT = TimeUnit.SECONDS;
    public static final long GRANULARITY = 1L;
    public static final int NUM_FIELDS = 6;
    private LinkedList<CronEntry> cronEntries = new LinkedList();
    private boolean doRun = false;

    public CronService() {
        super("CronService");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        Services servicesInstance = Services.getInstance();
        while (!servicesInstance.isInitialized()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this.doRun) {
            try {
                Thread.sleep(GRANULARITY_UNIT.toMillis(1L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (CronEntry entry : this.cronEntries) {
                if (entry.getDelayToNextExecutionInMillis() >= GRANULARITY_UNIT.toMillis(1L)) continue;
                String taskClassName = entry.getName();
                Class taskClass = this.instantiate(taskClassName);
                try {
                    if (taskClass != null) {
                        Task task = (Task)taskClass.newInstance();
                        logger.debug("Starting task {}", (Object)taskClassName);
                        StructrApp.getInstance().processTasks(task);
                        continue;
                    }
                    Tx tx = StructrApp.getInstance().tx();
                    Throwable throwable = null;
                    try {
                        Actions.callAsSuperUser(taskClassName, Collections.EMPTY_MAP);
                        tx.success();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (Throwable t) {
                    logger.warn("Exception while executing cron task {}: {}", (Object)taskClassName, (Object)t.getMessage());
                }
            }
        }
    }

    public void startService() throws Exception {
        this.doRun = true;
        this.start();
    }

    public void stopService() {
        this.doRun = false;
    }

    public boolean runOnStartup() {
        return true;
    }

    public boolean isRunning() {
        return this.doRun;
    }

    public void injectArguments(Command command) {
    }

    public void initialize(StructrServices services) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String taskList = (String)Settings.CronTasks.getValue();
        if (StringUtils.isNotBlank((CharSequence)taskList)) {
            for (String task : taskList.split("[ \\t]+")) {
                if (!StringUtils.isNotBlank((CharSequence)task)) continue;
                String expression = (String)Settings.getOrCreateStringSetting((String[])new String[]{task, EXPRESSION_SUFFIX}).getValue();
                if (StringUtils.isNotBlank((CharSequence)expression)) {
                    CronEntry entry = CronEntry.parse(task, expression);
                    if (entry != null) {
                        logger.info("Adding cron entry {} for {}", new Object[]{entry, task});
                        this.cronEntries.add(entry);
                        continue;
                    }
                    logger.warn("Unable to parse cron expression for taks {}, ignoring.", (Object)task);
                    continue;
                }
                logger.warn("No cron expression for task {}, ignoring.", (Object)task);
            }
        }
    }

    public void initialized() {
    }

    public void shutdown() {
        this.doRun = false;
    }

    public boolean isVital() {
        return false;
    }

    private Class instantiate(String taskClass) {
        try {
            return Class.forName(taskClass);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getModuleName() {
        return "cron";
    }
}

