/*
 * Decompiled with CFR 0.152.
 */
package org.structr.module;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.agent.Agent;
import org.structr.api.service.LicenseManager;
import org.structr.api.service.Service;
import org.structr.common.DefaultFactoryDefinition;
import org.structr.common.FactoryDefinition;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.PropertyGroup;
import org.structr.core.PropertyValidator;
import org.structr.core.Services;
import org.structr.core.Transformation;
import org.structr.core.ViewTransformation;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.GenericNode;
import org.structr.core.entity.Relation;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.module.StructrModule;
import org.structr.module.StructrModuleInfo;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.SchemaService;

public class JarConfigurationProvider
implements ConfigurationProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)JarConfigurationProvider.class.getName());
    public static final String DYNAMIC_TYPES_PACKAGE = "org.structr.dynamic";
    private static final Set<String> coreModules = new HashSet<String>(Arrays.asList("core", "rest", "ui"));
    private final Map<String, Class<? extends RelationshipInterface>> relationshipEntityClassCache = new ConcurrentHashMap<String, Class<? extends RelationshipInterface>>(1000);
    private final Map<String, Class<? extends NodeInterface>> nodeEntityClassCache = new ConcurrentHashMap<String, Class<? extends NodeInterface>>(1000);
    private final Map<String, Class<? extends Agent>> agentClassCache = new ConcurrentHashMap<String, Class<? extends Agent>>(100);
    private final Set<String> agentPackages = new LinkedHashSet<String>();
    private final Set<String> nodeEntityPackages = new LinkedHashSet<String>();
    private final Set<String> relationshipPackages = new LinkedHashSet<String>();
    private final Map<String, Class> combinedTypeRelationClassCache = new ConcurrentHashMap<String, Class>(100);
    private final Map<String, Set<Class>> interfaceCache = new ConcurrentHashMap<String, Set<Class>>(2000);
    private final Map<String, StructrModule> modules = new ConcurrentHashMap<String, StructrModule>(100);
    private final String fileSep = System.getProperty("file.separator");
    private final String pathSep = System.getProperty("path.separator");
    private final String fileSepEscaped = this.fileSep.replaceAll("\\\\", "\\\\\\\\");
    private final String testClassesDir = this.fileSep.concat("test-classes");
    private final String classesDir = this.fileSep.concat("classes");
    private final Map<String, Map<String, Set<PropertyKey>>> globalPropertyViewMap = new ConcurrentHashMap<String, Map<String, Set<PropertyKey>>>(2000);
    private final Map<String, Map<PropertyKey, Set<PropertyValidator>>> globalValidatorMap = new ConcurrentHashMap<String, Map<PropertyKey, Set<PropertyValidator>>>(100);
    private final Map<String, Map<String, PropertyKey>> globalClassDBNamePropertyMap = new ConcurrentHashMap<String, Map<String, PropertyKey>>(2000);
    private final Map<String, Map<String, PropertyKey>> globalClassJSNamePropertyMap = new ConcurrentHashMap<String, Map<String, PropertyKey>>(2000);
    private final Map<String, Map<String, PropertyGroup>> globalAggregatedPropertyGroupMap = new ConcurrentHashMap<String, Map<String, PropertyGroup>>(100);
    private final Map<String, Map<String, PropertyGroup>> globalPropertyGroupMap = new ConcurrentHashMap<String, Map<String, PropertyGroup>>(100);
    private final Map<String, Map<String, ViewTransformation>> viewTransformations = new ConcurrentHashMap<String, Map<String, ViewTransformation>>(100);
    private final Map<String, Set<Transformation<GraphObject>>> globalTransformationMap = new ConcurrentHashMap<String, Set<Transformation<GraphObject>>>(100);
    private final Map<String, Map<String, Method>> exportedMethodMap = new ConcurrentHashMap<String, Map<String, Method>>(100);
    private final Map<Class, Set<Class>> interfaceMap = new ConcurrentHashMap<Class, Set<Class>>(2000);
    private final Map<String, Class> reverseInterfaceMap = new ConcurrentHashMap<String, Class>(5000);
    private final Set<PropertyKey> globalKnownPropertyKeys = new LinkedHashSet<PropertyKey>();
    private final Set<String> dynamicViews = new LinkedHashSet<String>();
    private FactoryDefinition factoryDefinition = new DefaultFactoryDefinition();
    private LicenseManager licenseManager = null;

    @Override
    public void initialize(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
        this.scanResources();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Map<String, Class<? extends Agent>> getAgents() {
        return this.agentClassCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Class<? extends NodeInterface>> getNodeEntities() {
        Class<SchemaService> clazz = SchemaService.class;
        synchronized (SchemaService.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nodeEntityClassCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Class<? extends RelationshipInterface>> getRelationshipEntities() {
        Class<SchemaService> clazz = SchemaService.class;
        synchronized (SchemaService.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.relationshipEntityClassCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Class> getClassesForInterface(String simpleName) {
        Class<SchemaService> clazz = SchemaService.class;
        synchronized (SchemaService.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.interfaceCache.get(simpleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Class getNodeEntityClass(String simpleName) {
        Class nodeEntityClass = GenericNode.class;
        if (simpleName == null) return nodeEntityClass;
        if (simpleName.isEmpty()) return nodeEntityClass;
        Class<SchemaService> clazz = SchemaService.class;
        synchronized (SchemaService.class) {
            nodeEntityClass = this.nodeEntityClassCache.get(simpleName);
            if (nodeEntityClass != null) return nodeEntityClass;
            Iterator<String> iterator = this.nodeEntityPackages.iterator();
            while (iterator.hasNext()) {
                String possiblePath = iterator.next();
                if (possiblePath == null) continue;
                try {
                    Class<?> nodeClass = Class.forName(possiblePath + "." + simpleName);
                    if (Modifier.isAbstract(nodeClass.getModifiers())) continue;
                    this.nodeEntityClassCache.put(simpleName, nodeClass);
                    return nodeClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            return nodeEntityClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Class getRelationshipEntityClass(String name) {
        Class relationClass = AbstractRelationship.class;
        if (name == null || name.length() <= 0) return relationClass;
        Class<SchemaService> clazz = SchemaService.class;
        synchronized (SchemaService.class) {
            relationClass = this.relationshipEntityClassCache.get(name);
            if (relationClass != null) return relationClass;
            for (String possiblePath : this.relationshipPackages) {
                if (possiblePath == null) continue;
                try {
                    Class<?> nodeClass = Class.forName(possiblePath + "." + name);
                    if (Modifier.isAbstract(nodeClass.getModifiers())) continue;
                    this.relationshipEntityClassCache.put(name, nodeClass);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return nodeClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return relationClass;
        }
    }

    public Class<? extends Agent> getAgentClass(String name) {
        Class<? extends Agent> agentClass = null;
        if (name != null && name.length() > 0 && (agentClass = this.agentClassCache.get(name)) == null) {
            for (String possiblePath : this.agentPackages) {
                if (possiblePath == null) continue;
                try {
                    Class<?> nodeClass = Class.forName(possiblePath + "." + name);
                    this.agentClassCache.put(name, nodeClass);
                    return nodeClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return agentClass;
    }

    @Override
    public Map<String, Class> getInterfaces() {
        return this.reverseInterfaceMap;
    }

    @Override
    public void setRelationClassForCombinedType(String combinedType, Class clazz) {
        this.combinedTypeRelationClassCache.put(combinedType, clazz);
    }

    @Override
    public void setRelationClassForCombinedType(String sourceType, String relType, String targetType, Class clazz) {
        this.combinedTypeRelationClassCache.put(this.getCombinedType(sourceType, relType, targetType), clazz);
    }

    private Class getRelationClassForCombinedType(String combinedType) {
        Class cachedRelationClass = this.combinedTypeRelationClassCache.get(combinedType);
        if (cachedRelationClass != null) {
            return cachedRelationClass;
        }
        return null;
    }

    @Override
    public Class getRelationClassForCombinedType(String sourceTypeName, String relType, String targetTypeName) {
        if (sourceTypeName == null || relType == null || targetTypeName == null) {
            return null;
        }
        String combinedType = sourceTypeName.concat(" ").concat(relType).concat(" ").concat(targetTypeName);
        Class cachedRelationClass = this.getRelationClassForCombinedType(combinedType);
        if (cachedRelationClass != null) {
            return cachedRelationClass;
        }
        return this.findNearestMatchingRelationClass(sourceTypeName, relType, targetTypeName);
    }

    private List<Class<? extends RelationshipInterface>> getRelationClassCandidatesForRelType(String relType) {
        ArrayList<Class<? extends RelationshipInterface>> candidates = new ArrayList<Class<? extends RelationshipInterface>>();
        for (Class<? extends RelationshipInterface> candidate : this.getRelationshipEntities().values()) {
            Relation rel = this.instantiate(candidate);
            if (rel == null || !rel.name().equals(relType)) continue;
            candidates.add(candidate);
        }
        return candidates;
    }

    private Class findNearestMatchingRelationClass(String sourceTypeName, String relType, String targetTypeName) {
        Class sourceType = this.getNodeEntityClass(sourceTypeName);
        Class targetType = this.getNodeEntityClass(targetTypeName);
        TreeMap<Integer, Class<? extends RelationshipInterface>> candidates = new TreeMap<Integer, Class<? extends RelationshipInterface>>();
        for (Class<? extends RelationshipInterface> candidate : this.getRelationClassCandidatesForRelType(relType)) {
            Relation rel = this.instantiate(candidate);
            int distance = this.getDistance(rel.getSourceType(), sourceType, -1) + this.getDistance(rel.getTargetType(), targetType, -1);
            if (distance < 2000) continue;
            candidates.put(distance - 2000, candidate);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        Map.Entry candidateEntry = candidates.entrySet().iterator().next();
        Class c = (Class)candidateEntry.getValue();
        this.combinedTypeRelationClassCache.put(this.getCombinedType(sourceTypeName, relType, targetTypeName), c);
        return c;
    }

    private int getDistance(Class candidateType, Class type, int distance) {
        int d;
        Class<?>[] interfaces;
        if (distance >= 1000) {
            return distance;
        }
        ++distance;
        if (type == null) {
            return Integer.MIN_VALUE;
        }
        if (type.equals(Object.class)) {
            return Integer.MIN_VALUE;
        }
        if (type.equals(candidateType)) {
            return distance + 1000;
        }
        if (type.equals(NodeInterface.class)) {
            return Integer.MIN_VALUE;
        }
        if (!candidateType.isAssignableFrom(type)) {
            return Integer.MIN_VALUE;
        }
        ++distance;
        for (Class<?> iface : interfaces = type.getInterfaces()) {
            if (!iface.equals(candidateType)) continue;
            return distance + 1000;
        }
        Class superClass = type.getSuperclass();
        if (superClass != null && (d = this.getDistance(candidateType, superClass, ++distance)) >= 1000) {
            return d;
        }
        return distance;
    }

    @Override
    public Map<String, Method> getAnnotatedMethods(Class entityType, Class annotationType) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        Set<Class<?>> allTypes = this.getAllTypes(entityType);
        for (Class<?> type : allTypes) {
            for (Method method : type.getDeclaredMethods()) {
                if (method.getAnnotation(annotationType) == null) continue;
                methods.put(method.getName(), method);
            }
        }
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterEntityType(Class oldType) {
        Class<SchemaService> clazz = SchemaService.class;
        synchronized (SchemaService.class) {
            String simpleName = oldType.getSimpleName();
            String fqcn = oldType.getName();
            this.nodeEntityClassCache.remove(simpleName);
            this.relationshipEntityClassCache.remove(simpleName);
            this.nodeEntityPackages.remove(fqcn);
            this.relationshipPackages.remove(fqcn);
            this.globalPropertyViewMap.remove(fqcn);
            this.globalClassDBNamePropertyMap.remove(fqcn);
            this.globalClassJSNamePropertyMap.remove(fqcn);
            this.interfaceMap.remove(oldType);
            this.combinedTypeRelationClassCache.clear();
            for (Set<Class> classes : this.interfaceCache.values()) {
                if (!classes.contains(oldType)) continue;
                classes.remove(oldType);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void registerEntityType(Class type) {
        String simpleName = type.getSimpleName();
        String fqcn = type.getName();
        if (AbstractNode.class.isAssignableFrom(type)) {
            this.nodeEntityClassCache.put(simpleName, type);
            this.nodeEntityPackages.add(fqcn.substring(0, fqcn.lastIndexOf(".")));
            this.globalPropertyViewMap.remove(fqcn);
        }
        if (AbstractRelationship.class.isAssignableFrom(type)) {
            this.relationshipEntityClassCache.put(simpleName, type);
            this.relationshipPackages.add(fqcn.substring(0, fqcn.lastIndexOf(".")));
            this.globalPropertyViewMap.remove(fqcn);
        }
        for (Class<?> clazz : type.getInterfaces()) {
            String interfaceName = clazz.getSimpleName();
            Set<Class> classesForInterface = this.interfaceCache.get(interfaceName);
            if (classesForInterface == null) {
                classesForInterface = new LinkedHashSet<Class>();
                this.interfaceCache.put(interfaceName, classesForInterface);
            }
            classesForInterface.add(type);
        }
        try {
            Map<Field, PropertyKey> allProperties = this.getFieldValuesOfType(PropertyKey.class, type);
            Map<Field, View> views = this.getFieldValuesOfType(View.class, type);
            for (Map.Entry<Field, PropertyKey> entry : allProperties.entrySet()) {
                PropertyKey propertyKey = entry.getValue();
                Field field = entry.getKey();
                Class<?> declaringClass = field.getDeclaringClass();
                if (declaringClass != null) {
                    propertyKey.setDeclaringClass(declaringClass);
                    this.registerProperty(declaringClass, propertyKey);
                }
                this.registerProperty(type, propertyKey);
            }
            for (Map.Entry<Field, Object> entry : views.entrySet()) {
                Field field = entry.getKey();
                View view = (View)entry.getValue();
                for (Property propertyKey : view.properties()) {
                    this.registerPropertySet(field.getDeclaringClass(), view.name(), propertyKey);
                    this.registerPropertySet(type, view.name(), propertyKey);
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to register type {}, missing module?", (Object)type.getSimpleName());
            logger.debug("Unable to register type.", t);
            this.unregisterEntityType(type);
        }
        Map<String, Method> typeMethods = this.exportedMethodMap.get(fqcn);
        if (typeMethods == null) {
            typeMethods = new HashMap<String, Method>();
            this.exportedMethodMap.put(fqcn, typeMethods);
        }
        typeMethods.putAll(this.getAnnotatedMethods(type, Export.class));
        this.getInterfacesForType(type);
    }

    @Override
    public void registerEntityCreationTransformation(Class type, Transformation<GraphObject> transformation) {
        Set<Transformation<GraphObject>> transformations = this.getEntityCreationTransformationsForType(type);
        if (!transformations.contains(transformation)) {
            transformations.add(transformation);
        }
    }

    @Override
    public Set<Class> getInterfacesForType(Class type) {
        Set<Class> interfaces = this.interfaceMap.get(type);
        if (interfaces == null) {
            interfaces = new LinkedHashSet<Class>();
            this.interfaceMap.put(type, interfaces);
            for (Class<?> iface : type.getInterfaces()) {
                this.reverseInterfaceMap.put(iface.getSimpleName(), iface);
                interfaces.add(iface);
            }
        }
        return interfaces;
    }

    @Override
    public Map<String, Method> getExportedMethodsForType(Class type) {
        return this.exportedMethodMap.get(type.getName());
    }

    @Override
    public boolean isKnownProperty(PropertyKey key) {
        return this.globalKnownPropertyKeys.contains(key);
    }

    @Override
    public FactoryDefinition getFactoryDefinition() {
        return this.factoryDefinition;
    }

    @Override
    public void registerFactoryDefinition(FactoryDefinition factory) {
        this.factoryDefinition = factory;
    }

    @Override
    public void registerPropertyGroup(Class type, PropertyKey key, PropertyGroup propertyGroup) {
        this.getPropertyGroupMapForType(type).put(key.dbName(), propertyGroup);
    }

    @Override
    public void registerConvertedProperty(PropertyKey propertyKey) {
        this.globalKnownPropertyKeys.add(propertyKey);
    }

    @Override
    public synchronized Set<Transformation<GraphObject>> getEntityCreationTransformations(Class type) {
        TreeSet<Transformation<GraphObject>> transformations = new TreeSet<Transformation<GraphObject>>();
        for (Class localType = type; localType != null && !localType.equals(Object.class); localType = localType.getSuperclass()) {
            transformations.addAll(this.getEntityCreationTransformationsForType(localType));
        }
        return transformations;
    }

    @Override
    public PropertyGroup getPropertyGroup(Class type, PropertyKey key) {
        return this.getPropertyGroup(type, key.dbName());
    }

    @Override
    public PropertyGroup getPropertyGroup(Class type, String key) {
        PropertyGroup group = this.getAggregatedPropertyGroupMapForType(type).get(key);
        if (group == null) {
            for (Class localType = type; group == null && localType != null && !localType.equals(Object.class); localType = localType.getSuperclass()) {
                Class interfaceClass;
                group = this.getPropertyGroupMapForType(localType).get(key);
                if (group != null) continue;
                Iterator<Class> iterator = this.getInterfacesForType(localType).iterator();
                while (iterator.hasNext() && (group = this.getPropertyGroupMapForType(interfaceClass = iterator.next()).get(key)) == null) {
                }
            }
            this.getAggregatedPropertyGroupMapForType(type).put(key, group);
        }
        return group;
    }

    @Override
    public void registerViewTransformation(Class type, String view, ViewTransformation transformation) {
        this.getViewTransformationMapForType(type).put(view, transformation);
    }

    @Override
    public ViewTransformation getViewTransformation(Class type, String view) {
        return this.getViewTransformationMapForType(type).get(view);
    }

    @Override
    public Set<String> getPropertyViews() {
        LinkedHashSet<String> views = new LinkedHashSet<String>();
        for (Map<String, Set<PropertyKey>> view : this.globalPropertyViewMap.values()) {
            views.addAll(view.keySet());
        }
        views.addAll(this.dynamicViews);
        return Collections.unmodifiableSet(views);
    }

    @Override
    public Set<String> getPropertyViewsForType(Class type) {
        Map<String, Set<PropertyKey>> map = this.getPropertyViewMapForType(type);
        if (map != null) {
            return map.keySet();
        }
        return Collections.emptySet();
    }

    @Override
    public void registerDynamicViews(Set<String> dynamicViews) {
        this.dynamicViews.clear();
        this.dynamicViews.addAll(dynamicViews);
    }

    @Override
    public Set<PropertyKey> getPropertySet(Class type, String propertyView) {
        Map<String, Set<PropertyKey>> propertyViewMap = this.getPropertyViewMapForType(type);
        Set<PropertyKey> properties = propertyViewMap.get(propertyView);
        if (properties == null) {
            properties = new LinkedHashSet<PropertyKey>();
        }
        return Collections.unmodifiableSet(properties);
    }

    @Override
    public void registerPropertySet(Class type, String propertyView, PropertyKey ... propertySet) {
        Map<String, Set<PropertyKey>> propertyViewMap = this.getPropertyViewMapForType(type);
        Set<PropertyKey> properties = propertyViewMap.get(propertyView);
        if (properties == null) {
            properties = new LinkedHashSet<PropertyKey>();
            propertyViewMap.put(propertyView, properties);
        }
        for (PropertyKey key : propertySet) {
            if (properties.contains(key)) {
                properties.remove(key);
            }
            properties.add(key);
        }
    }

    @Override
    public void registerPropertySet(Class type, String propertyView, String propertyName) {
        this.registerPropertySet(type, propertyView, this.getPropertyKeyForJSONName(type, propertyName));
    }

    @Override
    public PropertyKey getPropertyKeyForDatabaseName(Class type, String dbName) {
        return this.getPropertyKeyForDatabaseName(type, dbName, true);
    }

    @Override
    public PropertyKey getPropertyKeyForDatabaseName(Class type, String dbName, boolean createGeneric) {
        Map<String, PropertyKey> classDBNamePropertyMap = this.getClassDBNamePropertyMapForType(type);
        GenericProperty key = classDBNamePropertyMap.get(dbName);
        if (key == null) {
            if (GraphObject.id.dbName().equals(dbName)) {
                return GraphObject.id;
            }
            if (createGeneric) {
                key = new GenericProperty(dbName);
            }
        }
        return key;
    }

    @Override
    public PropertyKey getPropertyKeyForJSONName(Class type, String jsonName) {
        return this.getPropertyKeyForJSONName(type, jsonName, true);
    }

    @Override
    public PropertyKey getPropertyKeyForJSONName(Class type, String jsonName, boolean createIfNotFound) {
        if (jsonName == null) {
            return null;
        }
        Map<String, PropertyKey> classJSNamePropertyMap = this.getClassJSNamePropertyMapForType(type);
        GenericProperty key = classJSNamePropertyMap.get(jsonName);
        if (key == null) {
            if (GraphObject.id.dbName().equals(jsonName)) {
                return GraphObject.id;
            }
            if (createIfNotFound) {
                key = new GenericProperty(jsonName);
            }
        }
        return key;
    }

    @Override
    public Set<PropertyValidator> getPropertyValidators(SecurityContext securityContext, Class type, PropertyKey propertyKey) {
        LinkedHashSet<PropertyValidator> validators = new LinkedHashSet<PropertyValidator>();
        Map<PropertyKey, Set<PropertyValidator>> validatorMap = null;
        for (Class localType = type; localType != null && !localType.equals(Object.class); localType = localType.getSuperclass()) {
            validatorMap = this.getPropertyValidatorMapForType(localType);
            Set<PropertyValidator> classValidators = validatorMap.get(propertyKey);
            if (classValidators != null) {
                validators.addAll((Collection<PropertyValidator>)validatorMap.get(propertyKey));
            }
            for (Class interfaceClass : this.getInterfacesForType(localType)) {
                Set<PropertyValidator> interfaceValidators = this.getPropertyValidatorMapForType(interfaceClass).get(propertyKey);
                if (interfaceValidators == null) continue;
                validators.addAll(interfaceValidators);
            }
        }
        return validators;
    }

    @Override
    public void registerProperty(Class type, PropertyKey propertyKey) {
        this.getClassDBNamePropertyMapForType(type).put(propertyKey.dbName(), propertyKey);
        this.getClassJSNamePropertyMapForType(type).put(propertyKey.jsonName(), propertyKey);
        this.registerPropertySet(type, "all", propertyKey);
        propertyKey.registrationCallback(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDynamicProperty(Class type, PropertyKey propertyKey) {
        Class<SchemaService> clazz = SchemaService.class;
        synchronized (SchemaService.class) {
            String typeName = type.getName();
            this.registerProperty(type, propertyKey);
            for (Class<? extends NodeInterface> possibleSubclass : this.nodeEntityClassCache.values()) {
                for (Class<?> supertype : this.getAllTypes(possibleSubclass)) {
                    if (!supertype.getName().equals(typeName)) continue;
                    this.registerProperty(possibleSubclass, propertyKey);
                    this.registerPropertySet(possibleSubclass, "ui", propertyKey);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Map<String, StructrModule> getModules() {
        return this.modules;
    }

    @Override
    public Map<String, Map<String, PropertyKey>> getTypeAndPropertyMapping() {
        return Collections.unmodifiableMap(this.globalClassJSNamePropertyMap);
    }

    private void scanResources() {
        Set<String> resourcePaths = this.getResourcesToScan();
        for (String resourcePath : resourcePaths) {
            this.scanResource(resourcePath);
        }
        logger.info("{} JARs scanned", (Object)resourcePaths.size());
    }

    private void scanResource(String resourceName) {
        try {
            StructrModuleInfo module = this.loadResource(resourceName);
            if (module != null) {
                this.importResource(module);
            } else {
                logger.warn("Module was null!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void importResource(StructrModuleInfo module) throws IOException {
        Set<String> classes = module.getClasses();
        for (String name : classes) {
            String className = StringUtils.removeStart((String)name, (String)".");
            try {
                Class<?> clazz = Class.forName(className);
                int modifiers = clazz.getModifiers();
                if (NodeInterface.class.isAssignableFrom(clazz)) {
                    this.registerEntityType(clazz);
                }
                if (AbstractRelationship.class.isAssignableFrom(clazz) && !Modifier.isAbstract(modifiers)) {
                    this.registerEntityType(clazz);
                }
                if (Service.class.isAssignableFrom(clazz) && !Modifier.isAbstract(modifiers)) {
                    Services.getInstance().registerServiceClass(clazz);
                }
                if (Agent.class.isAssignableFrom(clazz) && !Modifier.isAbstract(modifiers)) {
                    String simpleName = clazz.getSimpleName();
                    String fullName = clazz.getName();
                    this.agentClassCache.put(simpleName, clazz);
                    this.agentPackages.add(fullName.substring(0, fullName.lastIndexOf(".")));
                }
                if (!StructrModule.class.isAssignableFrom(clazz) || Modifier.isAbstract(modifiers)) continue;
                try {
                    StructrModule structrModule = (StructrModule)clazz.newInstance();
                    String moduleName = structrModule.getName();
                    if (this.modules.containsKey(moduleName) || !coreModules.contains(moduleName) && this.licenseManager != null && !this.licenseManager.isModuleLicensed(moduleName)) continue;
                    this.modules.put(moduleName, structrModule);
                    logger.info("Activating module {}", (Object)moduleName);
                    structrModule.onLoad(this.licenseManager);
                }
                catch (Throwable t) {
                    logger.warn("Unable to instantiate module " + clazz.getName(), t);
                }
            }
            catch (Throwable t) {
                logger.debug("Error trying to load class " + className, t);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StructrModuleInfo loadResource(String resource) throws IOException {
        StructrModuleInfo ret = new StructrModuleInfo(resource);
        Set<String> classes = ret.getClasses();
        if (resource.endsWith(".jar") || resource.endsWith(".war")) {
            try (JarFile jarFile = new JarFile(new File(resource), true);){
                String name;
                Attributes attrs;
                Manifest manifest = jarFile.getManifest();
                if (manifest == null || (attrs = manifest.getAttributes("Structr")) == null || (name = attrs.getValue("Structr-Module-Name")) == null || this.licenseManager != null && !this.licenseManager.isModuleLicensed(name)) return ret;
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.endsWith(".class")) continue;
                    IOUtils.copy((InputStream)jarFile.getInputStream(entry), (OutputStream)new ByteArrayOutputStream(65535));
                    if (this.licenseManager != null && !this.licenseManager.isValid(entry.getCodeSigners())) continue;
                    String fileEntry = entry.getName().replaceAll("[/]+", ".");
                    classes.add(fileEntry.substring(0, fileEntry.length() - 6));
                }
                return ret;
            }
        } else if (resource.endsWith(this.classesDir)) {
            this.addClassesRecursively(new File(resource), this.classesDir, classes);
            return ret;
        } else {
            if (!resource.endsWith(this.testClassesDir)) return ret;
            this.addClassesRecursively(new File(resource), this.testClassesDir, classes);
        }
        return ret;
    }

    private void addClassesRecursively(File dir, String prefix, Set<String> classes) {
        if (dir == null) {
            return;
        }
        int prefixLen = prefix.length();
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.addClassesRecursively(file, prefix, classes);
                continue;
            }
            try {
                String fileEntry = file.getAbsolutePath();
                fileEntry = fileEntry.substring(0, fileEntry.length() - 6);
                fileEntry = fileEntry.substring(fileEntry.indexOf(prefix) + prefixLen);
                fileEntry = fileEntry.replaceAll("[".concat(this.fileSepEscaped).concat("]+"), ".");
                if (fileEntry.startsWith(".")) {
                    fileEntry = fileEntry.substring(1);
                }
                classes.add(fileEntry);
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
    }

    private Relation instantiate(Class clazz) {
        try {
            return (Relation)clazz.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private String getCombinedType(String sourceType, String relType, String targetType) {
        return sourceType.concat(" ").concat(relType).concat(" ").concat(targetType);
    }

    private Set<String> getResourcesToScan() {
        String classPath = System.getProperty("java.class.path");
        TreeSet<String> modules = new TreeSet<String>();
        Pattern pattern = Pattern.compile(".*(structr).*(war|jar)");
        Matcher matcher = pattern.matcher("");
        for (String jarPath : classPath.split("[".concat(this.pathSep).concat("]+"))) {
            String lowerPath = jarPath.toLowerCase();
            if (lowerPath.endsWith(this.classesDir) || lowerPath.endsWith(this.testClassesDir)) {
                modules.add(jarPath);
                continue;
            }
            String moduleName = lowerPath.substring(lowerPath.lastIndexOf(this.pathSep) + 1);
            matcher.reset(moduleName);
            if (!matcher.matches()) continue;
            modules.add(jarPath);
        }
        for (String resource : Services.getInstance().getResources()) {
            String lowerResource = resource.toLowerCase();
            if (!lowerResource.endsWith(".jar") && !lowerResource.endsWith(".war")) continue;
            modules.add(resource);
        }
        return modules;
    }

    private <T> Map<Field, T> getFieldValuesOfType(Class<T> fieldType, Class entityType) {
        LinkedHashMap<Field, Object> fields = new LinkedHashMap<Field, Object>();
        Set<Class<?>> allTypes = this.getAllTypes(entityType);
        for (Class<?> type : allTypes) {
            for (Field field : type.getDeclaredFields()) {
                if (!fieldType.isAssignableFrom(field.getType()) || !Modifier.isStatic(field.getModifiers())) continue;
                try {
                    field.setAccessible(true);
                    Object value = field.get(null);
                    if (value == null) continue;
                    fields.put(field, value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return fields;
    }

    private Set<Class<?>> getAllTypes(Class<?> type) {
        LinkedList types = new LinkedList();
        Class<?> localType = type;
        do {
            this.collectAllInterfaces(localType, types);
            types.add(localType);
        } while ((localType = localType.getSuperclass()) != null && !localType.equals(Object.class));
        Collections.reverse(types);
        return new LinkedHashSet(types);
    }

    private void collectAllInterfaces(Class<?> type, List<Class<?>> interfaces) {
        if (interfaces.contains(type)) {
            return;
        }
        for (Class<?> iface : type.getInterfaces()) {
            this.collectAllInterfaces(iface, interfaces);
            interfaces.add(iface);
        }
    }

    private Map<String, Set<PropertyKey>> getPropertyViewMapForType(Class type) {
        Map<String, Set<PropertyKey>> propertyViewMap = this.globalPropertyViewMap.get(type.getName());
        if (propertyViewMap == null) {
            propertyViewMap = new LinkedHashMap<String, Set<PropertyKey>>();
            this.globalPropertyViewMap.put(type.getName(), propertyViewMap);
        }
        return propertyViewMap;
    }

    private Map<String, PropertyKey> getClassDBNamePropertyMapForType(Class type) {
        Map<String, PropertyKey> classDBNamePropertyMap = this.globalClassDBNamePropertyMap.get(type.getName());
        if (classDBNamePropertyMap == null) {
            classDBNamePropertyMap = new LinkedHashMap<String, PropertyKey>();
            this.globalClassDBNamePropertyMap.put(type.getName(), classDBNamePropertyMap);
        }
        return classDBNamePropertyMap;
    }

    private Map<String, PropertyKey> getClassJSNamePropertyMapForType(Class type) {
        Map<String, PropertyKey> classJSNamePropertyMap = this.globalClassJSNamePropertyMap.get(type.getName());
        if (classJSNamePropertyMap == null) {
            classJSNamePropertyMap = new LinkedHashMap<String, PropertyKey>();
            this.globalClassJSNamePropertyMap.put(type.getName(), classJSNamePropertyMap);
        }
        return classJSNamePropertyMap;
    }

    private Map<PropertyKey, Set<PropertyValidator>> getPropertyValidatorMapForType(Class type) {
        Map<PropertyKey, Set<PropertyValidator>> validatorMap = this.globalValidatorMap.get(type.getName());
        if (validatorMap == null) {
            validatorMap = new LinkedHashMap<PropertyKey, Set<PropertyValidator>>();
            this.globalValidatorMap.put(type.getName(), validatorMap);
        }
        return validatorMap;
    }

    private Map<String, PropertyGroup> getAggregatedPropertyGroupMapForType(Class type) {
        Map<String, PropertyGroup> groupMap = this.globalAggregatedPropertyGroupMap.get(type.getName());
        if (groupMap == null) {
            groupMap = new LinkedHashMap<String, PropertyGroup>();
            this.globalAggregatedPropertyGroupMap.put(type.getName(), groupMap);
        }
        return groupMap;
    }

    private Map<String, PropertyGroup> getPropertyGroupMapForType(Class type) {
        Map<String, PropertyGroup> groupMap = this.globalPropertyGroupMap.get(type.getName());
        if (groupMap == null) {
            groupMap = new LinkedHashMap<String, PropertyGroup>();
            this.globalPropertyGroupMap.put(type.getName(), groupMap);
        }
        return groupMap;
    }

    private Set<Transformation<GraphObject>> getEntityCreationTransformationsForType(Class type) {
        String name = type.getName();
        Set<Transformation<GraphObject>> transformations = this.globalTransformationMap.get(name);
        if (transformations == null) {
            transformations = new LinkedHashSet<Transformation<GraphObject>>();
            this.globalTransformationMap.put(name, transformations);
        }
        return transformations;
    }

    private Map<String, ViewTransformation> getViewTransformationMapForType(Class type) {
        Map<String, ViewTransformation> viewTransformationMap = this.viewTransformations.get(type.getName());
        if (viewTransformationMap == null) {
            viewTransformationMap = new LinkedHashMap<String, ViewTransformation>();
            this.viewTransformations.put(type.getName(), viewTransformationMap);
        }
        return viewTransformationMap;
    }

    private void consume(InputStream is) {
        byte[] buffer = new byte[32768];
        try (InputStream stream = is;){
            while (stream.read(buffer, 0, 32768) != -1) {
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
    }

    public void printCacheStats() {
        System.out.println("###################################################");
        System.out.println("" + this.relationshipEntityClassCache.size());
        System.out.println("" + this.nodeEntityClassCache.size());
        System.out.println("" + this.nodeEntityPackages.size());
        System.out.println("" + this.relationshipPackages.size());
        System.out.println("" + this.combinedTypeRelationClassCache.size());
        System.out.println("" + this.interfaceCache.size());
        System.out.println("" + this.globalPropertyViewMap.size());
        System.out.println("" + this.globalValidatorMap.size());
        System.out.println("" + this.globalClassDBNamePropertyMap.size());
        System.out.println("" + this.globalClassJSNamePropertyMap.size());
        System.out.println("" + this.globalAggregatedPropertyGroupMap.size());
        System.out.println("" + this.globalPropertyGroupMap.size());
        System.out.println("" + this.viewTransformations.size());
        System.out.println("" + this.globalTransformationMap.size());
        System.out.println("" + this.exportedMethodMap.size());
        System.out.println("" + this.interfaceMap.size());
        System.out.println("" + this.reverseInterfaceMap.size());
        System.out.println("" + this.globalKnownPropertyKeys.size());
        System.out.println("" + this.dynamicViews.size());
        System.out.println("###################################################");
    }
}

