/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.PropertiesNotFoundToken;
import org.structr.common.error.TypeToken;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.notion.DeserializationStrategy;
import org.structr.core.notion.TypeAndPropertySetDeserializationStrategy;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.RelationProperty;

public class SchemaDeserializationStrategy<S, T extends NodeInterface>
implements DeserializationStrategy<S, T> {
    private static final Logger logger = LoggerFactory.getLogger((String)TypeAndPropertySetDeserializationStrategy.class.getName());
    protected Set<PropertyKey> identifyingPropertyKeys = null;
    protected Set<PropertyKey> foreignPropertyKeys = null;
    protected RelationProperty<S> relationProperty = null;
    protected boolean createIfNotExisting = false;
    protected Class targetType = null;

    public SchemaDeserializationStrategy(boolean createIfNotExisting, Class targetType, Set<PropertyKey> identifyingPropertyKeys, Set<PropertyKey> foreignPropertyKeys) {
        this.createIfNotExisting = createIfNotExisting;
        this.identifyingPropertyKeys = identifyingPropertyKeys;
        this.foreignPropertyKeys = foreignPropertyKeys;
        this.targetType = targetType;
    }

    @Override
    public void setRelationProperty(RelationProperty<S> relationProperty) {
        this.relationProperty = relationProperty;
    }

    @Override
    public T deserialize(SecurityContext securityContext, Class<T> type, S source, Object context) throws FrameworkException {
        if (source instanceof Map) {
            PropertyMap attributes = PropertyMap.inputTypeToJavaType(securityContext, type, (Map)source);
            return this.deserialize(securityContext, type, attributes, context);
        }
        return null;
    }

    @Override
    private T deserialize(SecurityContext securityContext, Class<T> type, PropertyMap attributes, Object context) throws FrameworkException {
        App app = StructrApp.getInstance(securityContext);
        if (attributes != null) {
            Result<NodeInterface> result = Result.EMPTY_RESULT;
            PropertyMap foreignProperties = new PropertyMap();
            Iterator<PropertyKey> it = attributes.keySet().iterator();
            while (it.hasNext()) {
                PropertyKey key = it.next();
                if (!this.foreignPropertyKeys.contains(key)) continue;
                foreignProperties.put(key, attributes.get(key));
                it.remove();
            }
            String sourceTypeName = (String)((Map)context).get("name");
            if (attributes.containsKey(GraphObject.id)) {
                result = new Result<NodeInterface>(app.getNodeById(attributes.get(GraphObject.id)), false);
            } else {
                boolean attributesComplete = true;
                for (PropertyKey propertyKey : this.identifyingPropertyKeys) {
                    attributesComplete &= attributes.containsKey(propertyKey);
                }
                if (attributesComplete) {
                    PropertyMap identifyingKeyValues = new PropertyMap();
                    for (PropertyKey key : this.identifyingPropertyKeys) {
                        identifyingKeyValues.put(key, attributes.get(key));
                    }
                    result = app.nodeQuery(type).and(identifyingKeyValues).getResult();
                }
            }
            HashMap<String, PropertyMap> notionPropertyMap = (HashMap<String, PropertyMap>)securityContext.getAttribute("notionProperties");
            if (notionPropertyMap == null) {
                notionPropertyMap = new HashMap<String, PropertyMap>();
                securityContext.setAttribute("notionProperties", notionPropertyMap);
            }
            String errorMessage = null;
            int n = result.size();
            switch (n) {
                case 0: {
                    T newNode;
                    if (this.createIfNotExisting && (newNode = app.create(type, attributes)) != null) {
                        notionPropertyMap.put(this.getStorageKey(this.relationProperty, (NodeInterface)newNode, sourceTypeName), foreignProperties);
                        return newNode;
                    }
                    errorMessage = "No node found for the given properties and auto-creation not enabled";
                    break;
                }
                case 1: {
                    NodeInterface typedResult = this.getTypedResult(result, type);
                    notionPropertyMap.put(this.getStorageKey(this.relationProperty, typedResult, sourceTypeName), foreignProperties);
                    for (Map.Entry<PropertyKey, Object> entry : attributes.entrySet()) {
                        typedResult.setProperty(entry.getKey(), entry.getValue());
                    }
                    return (T)typedResult;
                }
                default: {
                    errorMessage = "Found " + n + " nodes for given type and properties, property set is ambiguous";
                    logger.error("Found {} nodes for given type and properties, property set is ambiguous!\nThis is often due to wrong modeling, or you should consider creating a uniquness constraint for " + type.getName(), (Object)n);
                }
            }
            throw new FrameworkException(404, errorMessage, new PropertiesNotFoundToken(type.getSimpleName(), (PropertyKey)AbstractNode.base, attributes));
        }
        return null;
    }

    private T getTypedResult(Result<T> result, Class<T> type) throws FrameworkException {
        T obj = result.get(0);
        if (!type.isAssignableFrom(obj.getClass())) {
            throw new FrameworkException(422, "Node type mismatch", new TypeToken(type.getSimpleName(), null, type.getSimpleName()));
        }
        return (T)((NodeInterface)result.get(0));
    }

    private String getStorageKey(RelationProperty relationProperty, NodeInterface newNode, String sourceTypeName) {
        switch (relationProperty.getDirectionKey()) {
            case "in": {
                return newNode.getName() + relationProperty.getRelation().name() + sourceTypeName;
            }
            case "out": {
                return sourceTypeName + relationProperty.getRelation().name() + newNode.getName();
            }
        }
        return null;
    }
}

