/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.service.Command;
import org.structr.api.service.InitializationCallback;
import org.structr.api.service.Service;
import org.structr.api.service.StructrServices;
import org.structr.common.AccessPathCache;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.graph.search.SearchCommand;
import org.structr.core.property.PropertyKey;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.NonIndexed;
import org.structr.schema.compiler.NodeExtender;

public class SchemaService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger((String)SchemaService.class.getName());
    private static final AtomicBoolean compiling = new AtomicBoolean(false);
    private static final AtomicBoolean updating = new AtomicBoolean(false);
    private static final Map<String, String> builtinTypeMap = new LinkedHashMap<String, String>();

    public void injectArguments(Command command) {
    }

    public void initialize(StructrServices services) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        services.registerInitializationCallback(new InitializationCallback(){

            public void initializationDone() {
                SchemaService.reloadSchema(new ErrorBuffer(), null);
            }
        });
    }

    public static void registerBuiltinTypeOverride(String type, String fqcn) {
        builtinTypeMap.put(type, fqcn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reloadSchema(ErrorBuffer errorBuffer, String initiatedBySessionId) {
        ConfigurationProvider config = StructrApp.getConfiguration();
        boolean success = true;
        if (compiling.compareAndSet(false, true)) {
            try {
                HashMap<String, Map<String, PropertyKey>> removedClasses = new HashMap<String, Map<String, PropertyKey>>(StructrApp.getConfiguration().getTypeAndPropertyMapping());
                LinkedHashSet<String> dynamicViews = new LinkedHashSet<String>();
                NodeExtender nodeExtender = new NodeExtender();
                nodeExtender.setInitiatedBySessionId(initiatedBySessionId);
                try (Tx tx = StructrApp.getInstance().tx();){
                    String auxSource;
                    SchemaService.ensureBuiltinTypesExist();
                    List<SchemaNode> schemaNodes = StructrApp.getInstance().nodeQuery(SchemaNode.class).getAsList();
                    for (SchemaNode schemaNode : schemaNodes) {
                        nodeExtender.addClass(schemaNode.getClassName(), schemaNode.getSource(errorBuffer));
                        auxSource = schemaNode.getAuxiliarySource();
                        if (auxSource != null) {
                            nodeExtender.addClass("_" + schemaNode.getClassName() + "Helper", auxSource);
                        }
                        dynamicViews.addAll(schemaNode.getViews());
                    }
                    for (SchemaRelationshipNode schemaRelationship : StructrApp.getInstance().nodeQuery(SchemaRelationshipNode.class).getAsList()) {
                        nodeExtender.addClass(schemaRelationship.getClassName(), schemaRelationship.getSource(errorBuffer));
                        auxSource = schemaRelationship.getAuxiliarySource();
                        if (auxSource != null) {
                            nodeExtender.addClass("_" + schemaRelationship.getClassName() + "Helper", auxSource);
                        }
                        dynamicViews.addAll(schemaRelationship.getViews());
                    }
                    Iterator<SchemaNode> iterator = SchemaService.class;
                    synchronized (SchemaService.class) {
                        SchemaRelationshipNode.clearPropagatingRelationshipTypes();
                        Map<String, Class> newTypes = nodeExtender.compile(errorBuffer);
                        for (Class newType : newTypes.values()) {
                            try {
                                config.registerEntityType(newType);
                                newType.newInstance();
                            }
                            catch (Throwable throwable) {}
                        }
                        removedClasses.keySet().removeAll(StructrApp.getConfiguration().getTypeAndPropertyMapping().keySet());
                        // ** MonitorExit[var10_13] (shouldn't be in output)
                        for (SchemaNode schemaNode : StructrApp.getInstance().nodeQuery(SchemaNode.class).getAsList()) {
                            schemaNode.createBuiltInSchemaEntities(errorBuffer);
                        }
                        boolean bl = success = !errorBuffer.hasError();
                        if (success) {
                            SearchCommand.clearInheritanceMap();
                            AccessPathCache.invalidate();
                            AbstractNode.clearRelationshipTemplateInstanceCache();
                            AbstractNode.clearPermissionResolutionCache();
                            config.registerDynamicViews(dynamicViews);
                            tx.success();
                        }
                    }
                }
                catch (Throwable t) {
                    logger.error("Unable to compile dynamic schema.", t);
                    success = false;
                }
                {
                    if (!Services.isTesting()) {
                        SchemaService.calculateHierarchy();
                        SchemaService.updateIndexConfiguration(removedClasses);
                    }
                }
            }
            finally {
                compiling.set(false);
            }
        }
        {
            return success;
        }
    }

    public void initialized() {
    }

    public void shutdown() {
    }

    public String getName() {
        return SchemaService.class.getName();
    }

    public boolean isRunning() {
        return true;
    }

    public static void ensureBuiltinTypesExist() throws FrameworkException {
        App app = StructrApp.getInstance();
        for (Map.Entry<String, String> entry : builtinTypeMap.entrySet()) {
            String type = entry.getKey();
            String fqcn = entry.getValue();
            SchemaNode schemaNode = app.nodeQuery(SchemaNode.class).andName(type).getFirst();
            if (schemaNode == null) {
                schemaNode = app.create(SchemaNode.class, type);
            }
            if (schemaNode == null) continue;
            schemaNode.setProperty(SchemaNode.extendsClass, fqcn);
            schemaNode.unlockSystemPropertiesOnce();
            schemaNode.setProperty(SchemaNode.isBuiltinType, true);
        }
    }

    public boolean isVital() {
        return true;
    }

    public String getModuleName() {
        return "core";
    }

    private static void calculateHierarchy() {
        try (Tx tx = StructrApp.getInstance().tx();){
            List<SchemaNode> schemaNodes = StructrApp.getInstance().nodeQuery(SchemaNode.class).getAsList();
            HashSet<String> alreadyCalculated = new HashSet<String>();
            LinkedHashMap<String, SchemaNode> map = new LinkedHashMap<String, SchemaNode>();
            for (SchemaNode schemaNode : schemaNodes) {
                map.put(schemaNode.getName(), schemaNode);
            }
            for (SchemaNode schemaNode : schemaNodes) {
                int relCount = schemaNode.getProperty(SchemaNode.relatedFrom).size() + schemaNode.getProperty(SchemaNode.relatedTo).size();
                int level = SchemaService.recursiveGetHierarchyLevel(map, alreadyCalculated, schemaNode, 0);
                schemaNode.setProperty(SchemaNode.hierarchyLevel, level);
                schemaNode.setProperty(SchemaNode.relCount, relCount);
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    private static int recursiveGetHierarchyLevel(Map<String, SchemaNode> map, Set<String> alreadyCalculated, SchemaNode schemaNode, int depth) {
        SchemaNode superSchemaNode;
        if (depth > 20) {
            return 20;
        }
        String superclass = schemaNode.getProperty(SchemaNode.extendsClass);
        if (superclass == null) {
            return 0;
        }
        if (superclass.startsWith("org.structr.dynamic.") && (superSchemaNode = map.get(superclass = superclass.substring(superclass.lastIndexOf(".") + 1))) != null) {
            return SchemaService.recursiveGetHierarchyLevel(map, alreadyCalculated, superSchemaNode, depth + 1) + 1;
        }
        return 0;
    }

    private static void updateIndexConfiguration(final Map<String, Map<String, PropertyKey>> removedClasses) {
        Thread indexUpdater = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (updating.compareAndSet(false, true)) {
                    try {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        App app = StructrApp.getInstance();
                        for (Map.Entry<String, Map<String, PropertyKey>> entry : StructrApp.getConfiguration().getTypeAndPropertyMapping().entrySet()) {
                            Class type = SchemaService.getType(entry.getKey());
                            if (type == null) continue;
                            String typeName = type.getSimpleName();
                            try {
                                Tx tx = app.tx();
                                Throwable throwable = null;
                                try {
                                    for (PropertyKey key : entry.getValue().values()) {
                                        String indexKey = "index." + typeName + "." + key.dbName();
                                        String value = app.getGlobalSetting(indexKey, null);
                                        boolean alreadySet = "true".equals(value);
                                        boolean createIndex = key.isIndexed() || key.isIndexedWhenEmpty();
                                        createIndex &= !NonIndexed.class.isAssignableFrom(type);
                                        if (createIndex &= NodeInterface.class.equals((Object)type) || !GraphObject.id.equals(key)) {
                                            if (alreadySet) continue;
                                            try {
                                                app.cypher("CREATE INDEX ON :" + typeName + "(" + key.dbName() + ")", params);
                                            }
                                            catch (Throwable t) {
                                                logger.warn("", t);
                                            }
                                            app.setGlobalSetting(indexKey, "true");
                                            continue;
                                        }
                                        if (!alreadySet) continue;
                                        try {
                                            app.cypher("DROP INDEX ON :" + typeName + "(" + key.dbName() + ")", params);
                                        }
                                        catch (Throwable t) {
                                            logger.warn("", t);
                                        }
                                        app.setGlobalSetting(indexKey, null);
                                    }
                                    tx.success();
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (tx == null) continue;
                                    if (throwable != null) {
                                        try {
                                            tx.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    tx.close();
                                }
                            }
                            catch (Throwable ignore) {
                                logger.warn("", ignore);
                            }
                        }
                        for (Map.Entry<String, Map<String, PropertyKey<Object>>> entry : removedClasses.entrySet()) {
                            String typeName = StringUtils.substringAfterLast((String)entry.getKey(), (String)".");
                            for (PropertyKey<Object> key : entry.getValue().values()) {
                                try {
                                    String indexKey = "index." + typeName + "." + key.dbName();
                                    String value = app.getGlobalSetting(indexKey, null);
                                    boolean exists = "true".equals(value);
                                    boolean dropIndex = key.isIndexed() || key.isIndexedWhenEmpty();
                                    if (!(dropIndex &= !GraphObject.id.equals(key)) || !exists) continue;
                                    try (Tx tx = app.tx();){
                                        app.cypher("DROP INDEX ON :" + typeName + "(" + key.dbName() + ")", params);
                                        tx.success();
                                    }
                                    catch (Throwable t) {
                                        logger.warn("", t);
                                    }
                                    app.setGlobalSetting(indexKey, null);
                                }
                                catch (FrameworkException frameworkException) {}
                            }
                        }
                    }
                    finally {
                        updating.set(false);
                    }
                }
            }
        });
        indexUpdater.setDaemon(true);
        indexUpdater.start();
    }

    private static Class getType(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return StructrApp.getConfiguration().getNodeEntityClass(StringUtils.substringAfterLast((String)name, (String)"."));
        }
    }
}

