/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.action;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.Principal;
import org.structr.core.entity.SchemaMethod;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;

public class Actions {
    private static final Logger logger = LoggerFactory.getLogger((String)Actions.class.getName());
    public static final String NOTIFICATION_LOGIN = "onStructrLogin";
    public static final String NOTIFICATION_LOGOUT = "onStructrLogout";

    public static Object execute(SecurityContext securityContext, GraphObject entity, String source, String methodName) throws FrameworkException, UnlicensedException {
        return Actions.execute(securityContext, entity, source, Collections.EMPTY_MAP, methodName);
    }

    public static Object execute(SecurityContext securityContext, GraphObject entity, String source, Map<String, Object> parameters, String methodName) throws FrameworkException, UnlicensedException {
        ActionContext context = new ActionContext(securityContext, parameters);
        Object result = Scripting.evaluate(context, entity, source, methodName);
        if (context.hasError()) {
            throw new FrameworkException(422, "Server-side scripting error", context.getErrorBuffer());
        }
        return result;
    }

    public static Object call(String key, Principal user) throws FrameworkException, UnlicensedException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user", user);
        return Actions.callAsSuperUser(key, params);
    }

    public static Object callAsSuperUser(String key, Map<String, Object> parameters) throws FrameworkException, UnlicensedException {
        SecurityContext superUserContext = SecurityContext.getSuperUserInstance();
        return Actions.callWithSecurityContext(key, superUserContext, parameters);
    }

    public static Object callWithSecurityContext(String key, SecurityContext securityContext, Map<String, Object> parameters) throws FrameworkException, UnlicensedException {
        App app = StructrApp.getInstance(securityContext);
        List<SchemaMethod> methods = app.nodeQuery(SchemaMethod.class).andName(key).getAsList();
        if (methods.isEmpty()) {
            if (!NOTIFICATION_LOGIN.equals(key) && !NOTIFICATION_LOGOUT.equals(key)) {
                logger.warn("Tried to call method {} but no SchemaMethod entity was found.", (Object)key);
            }
        } else {
            for (SchemaMethod method : methods) {
                AbstractSchemaNode entity = method.getProperty(SchemaMethod.schemaNode);
                if (entity == null) {
                    String source = method.getProperty(SchemaMethod.source);
                    if (source != null) {
                        return Actions.execute(securityContext, null, "${" + source + "}", parameters, method.getName());
                    }
                    logger.warn("Schema method {} has no source code, will NOT be executed.", (Object)key);
                    continue;
                }
                logger.warn("Schema method {} is attached to an entity, will NOT be executed.", (Object)key);
            }
        }
        return null;
    }

    public static enum Type {
        Create("onCreation", "SecurityContext securityContext, ErrorBuffer errorBuffer", "securityContext, errorBuffer", "onCreate"),
        Save("onModification", "SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue", "securityContext, errorBuffer, modificationQueue", "onSave"),
        Delete("onDeletion", "SecurityContext securityContext, ErrorBuffer errorBuffer, PropertyMap properties", "securityContext, errorBuffer, properties", "onDelete"),
        Custom("", "", "", "custom");

        private String method = null;
        private String logName = null;
        private String signature = null;
        private String parameters = null;

        private Type(String method, String signature, String parameters, String logName) {
            this.method = method;
            this.signature = signature;
            this.parameters = parameters;
            this.logName = logName;
        }

        public String getMethod() {
            return this.method;
        }

        public String getLogName() {
            return this.logName;
        }

        public String getSignature() {
            return this.signature;
        }

        public String getParameters() {
            return this.parameters;
        }
    }
}

