/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.action;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Setting;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.StructrApp;
import org.structr.core.function.Functions;
import org.structr.core.property.StringProperty;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Hint;
import org.structr.schema.parser.DatePropertyParser;

public abstract class Function<S, T>
extends Hint {
    protected static final Logger logger = LoggerFactory.getLogger((String)Functions.class.getName());

    public abstract T apply(ActionContext var1, Object var2, S[] var3) throws FrameworkException;

    public abstract String usage(boolean var1);

    protected void logParameterError(Object caller, Object[] parameters, boolean inJavaScriptContext) {
        logger.warn("{}: unsupported parameter combination/count in \"{}\". Parameters: {}. {}", new Object[]{this.getName(), caller, this.getParametersAsString(parameters), this.usage(inJavaScriptContext)});
    }

    protected void logException(Object caller, Throwable t, Object[] parameters) {
        this.logException(t, "{}: Exception in \"{}\" for parameters: {}", new Object[]{this.getName(), caller, this.getParametersAsString(parameters)});
    }

    protected void logException(Throwable t, String msg, Object[] messageParams) {
        logger.error(msg, (Object)messageParams, (Object)t);
    }

    protected String getParametersAsString(Object[] sources) {
        return Arrays.toString(sources);
    }

    protected boolean arrayHasMinLengthAndAllElementsNotNull(Object[] array, Integer minLength) throws IllegalArgumentException {
        if (array == null) {
            return false;
        }
        if (minLength != null) {
            if (array.length < minLength) {
                throw new IllegalArgumentException();
            }
            for (Object element : array) {
                if (element != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(Object[] array, int minLength, int maxLength) throws IllegalArgumentException {
        if (array == null) {
            return false;
        }
        if (array.length < minLength || array.length > maxLength) {
            throw new IllegalArgumentException();
        }
        for (Object element : array) {
            if (element != null) continue;
            return false;
        }
        return true;
    }

    protected boolean arrayHasLengthAndAllElementsNotNull(Object[] array, int length) throws IllegalArgumentException {
        if (array == null) {
            return false;
        }
        if (array.length != length) {
            throw new IllegalArgumentException();
        }
        for (Object element : array) {
            if (element != null) continue;
            return false;
        }
        return true;
    }

    protected Double getDoubleOrNull(Object obj) {
        try {
            if (obj instanceof Date) {
                return ((Date)obj).getTime();
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            Date date = DatePropertyParser.parseISO8601DateString(obj.toString());
            if (date != null) {
                return date.getTime();
            }
            return Double.parseDouble(obj.toString());
        }
        catch (Throwable t) {
            this.logException(t, "{}: Exception parsing \"1\"", new Object[]{this.getName(), obj});
            return null;
        }
    }

    protected Integer parseInt(Object source) {
        if (source instanceof Integer) {
            return (Integer)source;
        }
        if (source instanceof Number) {
            return ((Number)source).intValue();
        }
        if (source instanceof String) {
            return Integer.parseInt((String)source);
        }
        return null;
    }

    protected String encodeURL(String source) {
        try {
            return URLEncoder.encode(source, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return source;
        }
    }

    protected boolean valueEquals(Object obj1, Object obj2) {
        if (obj1 instanceof Enum || obj2 instanceof Enum) {
            return obj1.toString().equals(obj2.toString());
        }
        return this.eq(obj1, obj2);
    }

    protected double getDoubleForComparison(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        try {
            return Double.valueOf(obj.toString());
        }
        catch (Throwable t) {
            this.logException(t, "{}: Exception parsing \"1\"", new Object[]{this.getName(), obj});
            return 0.0;
        }
    }

    protected boolean gt(Object o1, Object o2) {
        if (o1 != null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null || o1 == null && o2 == null) {
            return false;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return this.compareNumberNumber(o1, o2) > 0;
        }
        if (o1 instanceof String && o2 instanceof String) {
            return this.compareStringString(o1, o2) > 0;
        }
        if (o1 instanceof Date && o2 instanceof Date) {
            return this.compareDateDate(o1, o2) > 0;
        }
        if (o1 instanceof Date && o2 instanceof String) {
            return this.compareDateString(o1, o2) > 0;
        }
        if (o1 instanceof String && o2 instanceof Date) {
            return this.compareStringDate(o1, o2) > 0;
        }
        if (o1 instanceof Boolean && o2 instanceof String) {
            return this.compareBooleanString((Boolean)o1, (String)o2) > 0;
        }
        if (o1 instanceof String && o2 instanceof Boolean) {
            return this.compareStringBoolean((String)o1, (Boolean)o2) > 0;
        }
        if (o1 instanceof Number && o2 instanceof String) {
            return this.compareNumberString((Number)o1, (String)o2) > 0;
        }
        if (o1 instanceof String && o2 instanceof Number) {
            return this.compareStringNumber((String)o1, (Number)o2) > 0;
        }
        return this.compareStringString(o1.toString(), o2.toString()) > 0;
    }

    protected boolean lt(Object o1, Object o2) {
        if (o1 == null && o2 != null) {
            return true;
        }
        if (o1 != null && o2 == null || o1 == null && o2 == null) {
            return false;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return this.compareNumberNumber(o1, o2) < 0;
        }
        if (o1 instanceof String && o2 instanceof String) {
            return this.compareStringString(o1, o2) < 0;
        }
        if (o1 instanceof Date && o2 instanceof Date) {
            return this.compareDateDate(o1, o2) < 0;
        }
        if (o1 instanceof Date && o2 instanceof String) {
            return this.compareDateString(o1, o2) < 0;
        }
        if (o1 instanceof String && o2 instanceof Date) {
            return this.compareStringDate(o1, o2) < 0;
        }
        if (o1 instanceof Boolean && o2 instanceof String) {
            return this.compareBooleanString((Boolean)o1, (String)o2) < 0;
        }
        if (o1 instanceof String && o2 instanceof Boolean) {
            return this.compareStringBoolean((String)o1, (Boolean)o2) < 0;
        }
        if (o1 instanceof Number && o2 instanceof String) {
            return this.compareNumberString((Number)o1, (String)o2) < 0;
        }
        if (o1 instanceof String && o2 instanceof Number) {
            return this.compareStringNumber((String)o1, (Number)o2) < 0;
        }
        return this.compareStringString(o1.toString(), o2.toString()) < 0;
    }

    protected boolean gte(Object o1, Object o2) {
        return this.eq(o1, o2) || this.gt(o1, o2);
    }

    protected boolean lte(Object o1, Object o2) {
        return this.eq(o1, o2) || this.lt(o1, o2);
    }

    protected String getSandboxFileName(String source) throws IOException {
        String basePath = Settings.getBasePath();
        if (!basePath.isEmpty()) {
            File sourceFile;
            String finalFilePath;
            String exchangeDir = Settings.getFullSettingPath((Setting)Settings.DataExchangePath);
            File dir = new File(exchangeDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ((finalFilePath = dir.getCanonicalPath().concat(File.separator).concat(source)).equals((sourceFile = new File(finalFilePath)).getCanonicalPath())) {
                return finalFilePath;
            }
            logger.warn("File path might contain directory traversal attack, aborting. Path: '{}'", (Object)source);
        } else {
            logger.warn("Unable to determine base.path from structr.conf, no data input/output possible.");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File getServerlogFile() throws IOException {
        String basePath = Settings.getBasePath();
        if (!basePath.isEmpty()) {
            boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
            String logPath = basePath.endsWith(File.separator) ? basePath.concat("logs" + File.separator) : basePath.concat(File.separator + "logs" + File.separator);
            File logFile = new File(logPath.concat(isDebug ? "debug.log" : "server.log"));
            if (logFile.exists()) return logFile;
            logger.warn("Server log does not exist");
            return null;
        } else {
            logger.warn("Unable to determine base.path from structr.conf, no data input/output possible.");
        }
        return null;
    }

    protected static String serialize(Gson gson, Map<String, Object> map) {
        return gson.toJson(map, new TypeToken<Map<String, String>>(){}.getType());
    }

    protected static Map<String, Object> deserialize(Gson gson, String source) {
        return (Map)gson.fromJson(source, new TypeToken<Map<String, Object>>(){}.getType());
    }

    protected static void recursivelyConvertMapToGraphObjectMap(GraphObjectMap destination, Map<String, Object> source, int depth) {
        if (depth > 20) {
            return;
        }
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            ConfigurationProvider provider = StructrApp.getConfiguration();
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map map = (Map)value;
                GraphObjectMap obj = new GraphObjectMap();
                destination.put(provider.getPropertyKeyForJSONName(obj.getClass(), key), obj);
                Function.recursivelyConvertMapToGraphObjectMap(obj, map, depth + 1);
                continue;
            }
            if (value instanceof Collection) {
                LinkedList<GraphObjectMap> list = new LinkedList<GraphObjectMap>();
                Collection collection = (Collection)value;
                for (Object obj : collection) {
                    if (obj instanceof Map) {
                        GraphObjectMap container = new GraphObjectMap();
                        list.add(container);
                        Function.recursivelyConvertMapToGraphObjectMap(container, (Map)obj, depth + 1);
                        continue;
                    }
                    list.add((GraphObjectMap)obj);
                }
                destination.put(provider.getPropertyKeyForJSONName(list.getClass(), key), list);
                continue;
            }
            destination.put(value != null ? provider.getPropertyKeyForJSONName(value.getClass(), key) : new StringProperty(key), value);
        }
    }

    public static GraphObjectMap toGraphObjectMap(Map<String, Object> src) {
        GraphObjectMap dest = new GraphObjectMap();
        Function.recursivelyConvertMapToGraphObjectMap(dest, src, 0);
        return dest;
    }

    public static Object numberOrString(String value) {
        if (value != null) {
            if ("true".equals(value.toLowerCase())) {
                return true;
            }
            if ("false".equals(value.toLowerCase())) {
                return false;
            }
            if (NumberUtils.isCreatable((String)value)) {
                return NumberUtils.createNumber((String)value);
            }
        }
        return value;
    }

    private boolean eq(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null || o1 != null && o2 == null) {
            return false;
        }
        try {
            if (o1 instanceof Number && o2 instanceof Number) {
                return this.compareNumberNumber(o1, o2) == 0;
            }
            if (o1 instanceof String && o2 instanceof String) {
                return this.compareStringString(o1, o2) == 0;
            }
            if (o1 instanceof Date && o2 instanceof Date) {
                return this.compareDateDate(o1, o2) == 0;
            }
            if (o1 instanceof Date && o2 instanceof String) {
                return this.compareDateString(o1, o2) == 0;
            }
            if (o1 instanceof String && o2 instanceof Date) {
                return this.compareStringDate(o1, o2) == 0;
            }
            if (o1 instanceof Boolean && o2 instanceof String) {
                return this.compareBooleanString((Boolean)o1, (String)o2) == 0;
            }
            if (o1 instanceof String && o2 instanceof Boolean) {
                return this.compareStringBoolean((String)o1, (Boolean)o2) == 0;
            }
            if (o1 instanceof Number && o2 instanceof String) {
                return this.compareNumberString((Number)o1, (String)o2) == 0;
            }
            if (o1 instanceof String && o2 instanceof Number) {
                return this.compareStringNumber((String)o1, (Number)o2) == 0;
            }
            return this.compareStringString(o1.toString(), o2.toString()) == 0;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private int compareBooleanBoolean(Object o1, Object o2) {
        Boolean value1 = (Boolean)o1;
        Boolean value2 = (Boolean)o2;
        return value1.compareTo(value2);
    }

    private int compareNumberNumber(Object o1, Object o2) {
        Double value1 = this.getDoubleForComparison(o1);
        Double value2 = this.getDoubleForComparison(o2);
        return value1.compareTo(value2);
    }

    private int compareStringString(Object o1, Object o2) {
        String value1 = (String)o1;
        String value2 = (String)o2;
        return value1.compareTo(value2);
    }

    private int compareDateDate(Object o1, Object o2) {
        Date value1 = (Date)o1;
        Date value2 = (Date)o2;
        return value1.compareTo(value2);
    }

    private int compareDateString(Object o1, Object o2) {
        String value1 = DatePropertyParser.format((Date)o1, (String)Settings.DefaultDateFormat.getValue());
        String value2 = (String)o2;
        return value1.compareTo(value2);
    }

    private int compareStringDate(Object o1, Object o2) {
        String value1 = (String)o1;
        String value2 = DatePropertyParser.format((Date)o2, (String)Settings.DefaultDateFormat.getValue());
        return value1.compareTo(value2);
    }

    private int compareBooleanString(Boolean o1, String o2) {
        return o1.compareTo(Boolean.valueOf(o2));
    }

    private int compareStringBoolean(String o1, Boolean o2) {
        return Boolean.valueOf(o1).compareTo(o2);
    }

    private int compareNumberString(Number o1, String o2) {
        Double value2;
        Double value1 = this.getDoubleForComparison(o1);
        try {
            value2 = Double.parseDouble(o2);
        }
        catch (NumberFormatException nfe) {
            value2 = Double.NEGATIVE_INFINITY;
        }
        return value1.compareTo(value2);
    }

    private int compareStringNumber(String o1, Number o2) {
        Double value1;
        try {
            value1 = Double.parseDouble(o1);
        }
        catch (NumberFormatException nfe) {
            value1 = Double.NEGATIVE_INFINITY;
        }
        Double value2 = this.getDoubleForComparison(o2);
        return value1.compareTo(value2);
    }
}

