/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.compiler;

import java.io.IOException;
import java.security.SecureClassLoader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.structr.schema.compiler.JavaClassObject;

public class ClassFileManager
extends ForwardingJavaFileManager {
    private final Map<String, JavaClassObject> objects = new LinkedHashMap<String, JavaClassObject>();

    public ClassFileManager(StandardJavaFileManager standardManager) {
        super(standardManager);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return new SecureClassLoader(){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                JavaClassObject obj = (JavaClassObject)ClassFileManager.this.objects.get(name);
                if (obj != null) {
                    byte[] b = obj.getBytes();
                    return super.defineClass(name, obj.getBytes(), 0, b.length);
                }
                throw new ClassNotFoundException(name);
            }
        };
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavaClassObject obj = new JavaClassObject(className, kind);
        this.objects.put(className, obj);
        return obj;
    }
}

