/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.compiler;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.error.DiagnosticErrorToken;
import org.structr.common.error.ErrorBuffer;
import org.structr.core.Services;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.TransactionCommand;
import org.structr.schema.compiler.CharSequenceJavaFileObject;
import org.structr.schema.compiler.ClassFileManager;

public class NodeExtender {
    private static final Logger logger = LoggerFactory.getLogger((String)NodeExtender.class.getName());
    private static final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private static final JavaFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(null, null, null));
    private static final ClassLoader classLoader = fileManager.getClassLoader(null);
    private static final Map<String, Class> classes = new TreeMap<String, Class>();
    private List<JavaFileObject> jfiles = new ArrayList<JavaFileObject>();
    private Set<String> fqcns = new LinkedHashSet<String>();
    private String initiatedBySessionId = null;

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static Class getClass(String fqcn) {
        return classes.get(fqcn);
    }

    public static Map<String, Class> getClasses() {
        return classes;
    }

    public void addClass(String className, String content) throws ClassNotFoundException {
        if (className != null && content != null) {
            String packageName = "org.structr.dynamic";
            this.jfiles.add(new CharSequenceJavaFileObject(className, content));
            this.fqcns.add("org.structr.dynamic".concat(".".concat(className)));
            if (((Boolean)Settings.LogSchemaOutput.getValue()).booleanValue()) {
                System.out.println("########################################################################################################################################################");
                System.out.println(content);
            }
        }
    }

    public synchronized Map<String, Class> compile(ErrorBuffer errorBuffer) throws ClassNotFoundException {
        StringWriter errorWriter = new StringWriter();
        LinkedList newClasses = new LinkedList();
        if (!this.jfiles.isEmpty()) {
            logger.debug("Compiling {} dynamic entities...", (Object)this.jfiles.size());
            Boolean success = compiler.getTask(errorWriter, fileManager, new Listener(errorBuffer), null, null, this.jfiles).call();
            if (success.booleanValue()) {
                ClassLoader loader = fileManager.getClassLoader(null);
                for (String string : this.fqcns) {
                    try {
                        newClasses.add(loader.loadClass(string));
                    }
                    catch (Throwable t) {
                        logger.warn("Unable to load dynamic entity {}: {}", new Object[]{string, t.toString()});
                        logger.warn("", t);
                        success = false;
                    }
                }
                if (success.booleanValue()) {
                    for (Class clazz : classes.values()) {
                        StructrApp.getConfiguration().unregisterEntityType(clazz);
                    }
                    classes.clear();
                    for (Class clazz : newClasses) {
                        classes.put(clazz.getName(), clazz);
                    }
                    logger.info("Successfully compiled {} dynamic entities: {}", new Object[]{this.jfiles.size(), this.jfiles.stream().map(f -> f.getName().replaceFirst("/", "")).collect(Collectors.joining(", "))});
                    LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                    data.put("success", true);
                    TransactionCommand.simpleBroadcast("SCHEMA_COMPILED", data, this.getInitiatedBySessionId());
                    Services.getInstance().setOverridingSchemaTypesAllowed(false);
                }
            }
        }
        return classes;
    }

    public String getInitiatedBySessionId() {
        return this.initiatedBySessionId;
    }

    public void setInitiatedBySessionId(String initiatedBySessionId) {
        this.initiatedBySessionId = initiatedBySessionId;
    }

    private static class Listener
    implements DiagnosticListener<JavaFileObject> {
        private ErrorBuffer errorBuffer = null;

        public Listener(ErrorBuffer errorBuffer) {
            this.errorBuffer = errorBuffer;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            if (diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR)) {
                JavaFileObject obj = diagnostic.getSource();
                String name = "unknown";
                if (obj != null && obj instanceof CharSequenceJavaFileObject) {
                    name = ((CharSequenceJavaFileObject)obj).getClassName();
                }
                this.errorBuffer.add(new DiagnosticErrorToken(name, diagnostic));
                logger.warn("Unable to compile dynamic entity {}: {}", new Object[]{name, diagnostic.getMessage(Locale.ENGLISH)});
            }
        }
    }
}

