/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.export.StructrStringProperty;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonEnumProperty;

public class StructrEnumProperty
extends StructrStringProperty
implements JsonEnumProperty {
    protected Set<String> enums = new TreeSet<String>();

    public StructrEnumProperty(StructrTypeDefinition parent, String name) {
        super(parent, name);
    }

    @Override
    public JsonEnumProperty setEnums(String ... values) {
        for (String value : values) {
            this.enums.add(value.trim());
        }
        return this;
    }

    @Override
    public Set<String> getEnums() {
        return this.enums;
    }

    @Override
    Map<String, Object> serialize() {
        Map<String, Object> map = super.serialize();
        map.put("enum", this.enums);
        map.remove("format");
        return map;
    }

    @Override
    void deserialize(Map<String, Object> source) {
        super.deserialize(source);
        Object enumValues = source.get("enum");
        if (enumValues != null) {
            if (!(enumValues instanceof List)) {
                throw new IllegalStateException("Invalid enum values for property " + this.name + ", expected array.");
            }
        } else {
            throw new IllegalStateException("Missing enum values for property " + this.name);
        }
        this.enums.addAll((List)enumValues);
    }

    @Override
    void deserialize(SchemaProperty schemaProperty) {
        super.deserialize(schemaProperty);
        this.setEnums(schemaProperty.getEnumDefinitions().toArray(new String[0]));
    }

    @Override
    SchemaProperty createDatabaseSchema(App app, AbstractSchemaNode schemaNode) throws FrameworkException {
        SchemaProperty property = super.createDatabaseSchema(app, schemaNode);
        property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.Enum.name());
        property.setProperty(SchemaProperty.format, StringUtils.join(this.getEnums(), (String)", "));
        return property;
    }
}

