/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.export.StructrStringProperty;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonFunctionProperty;

public class StructrFunctionProperty
extends StructrStringProperty
implements JsonFunctionProperty {
    protected String readFunction = null;
    protected String writeFunction = null;
    protected String contentType = null;

    public StructrFunctionProperty(StructrTypeDefinition parent, String name) {
        super(parent, name);
    }

    @Override
    public JsonFunctionProperty setReadFunction(String readFunction) {
        this.readFunction = readFunction;
        return this;
    }

    @Override
    public String getType() {
        return "function";
    }

    @Override
    public String getReadFunction() {
        return this.readFunction;
    }

    @Override
    public JsonFunctionProperty setWriteFunction(String writeFunction) {
        this.writeFunction = writeFunction;
        return this;
    }

    @Override
    public String getWriteFunction() {
        return this.writeFunction;
    }

    @Override
    public JsonFunctionProperty setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    Map<String, Object> serialize() {
        Map<String, Object> map = super.serialize();
        if (this.readFunction != null) {
            map.put("readFunction", this.readFunction);
        }
        if (this.writeFunction != null) {
            map.put("writeFunction", this.writeFunction);
        }
        return map;
    }

    @Override
    void deserialize(Map<String, Object> source) {
        Object contentTypeValue;
        Object writeFunctionValue;
        super.deserialize(source);
        Object readFunctionValue = source.get("readFunction");
        if (readFunctionValue != null) {
            if (readFunctionValue instanceof String) {
                this.readFunction = (String)readFunctionValue;
            } else {
                throw new IllegalStateException("Invalid readFunction for property " + this.name + ", expected string.");
            }
        }
        if ((writeFunctionValue = source.get("writeFunction")) != null) {
            if (writeFunctionValue instanceof String) {
                this.writeFunction = (String)writeFunctionValue;
            } else {
                throw new IllegalStateException("Invalid writeFunction for property " + this.name + ", expected string.");
            }
        }
        if ((contentTypeValue = source.get("contentType")) != null) {
            if (contentTypeValue instanceof String) {
                this.contentType = (String)contentTypeValue;
            } else {
                throw new IllegalStateException("Invalid contentType for property " + this.name + ", expected string.");
            }
        }
    }

    @Override
    void deserialize(SchemaProperty property) {
        super.deserialize(property);
        this.setReadFunction(property.getReadFunction());
        this.setWriteFunction(property.getWriteFunction());
        this.setContentType(property.getSourceContentType());
    }

    @Override
    SchemaProperty createDatabaseSchema(App app, AbstractSchemaNode schemaNode) throws FrameworkException {
        SchemaProperty property = super.createDatabaseSchema(app, schemaNode);
        String contentType = this.getContentType();
        if (contentType != null) {
            switch (contentType) {
                case "application/x-structr-javascript": 
                case "application/x-structr-script": {
                    property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.Function.name());
                    break;
                }
                case "application/x-cypher": {
                    property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.Cypher.name());
                }
            }
        } else {
            property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.Function.name());
        }
        property.setProperty(SchemaProperty.readFunction, this.readFunction);
        property.setProperty(SchemaProperty.writeFunction, this.writeFunction);
        return property;
    }
}

