/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.export.StructrPropertyDefinition;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonIntegerProperty;
import org.structr.schema.parser.IntPropertyParser;

public class StructrIntegerProperty
extends StructrPropertyDefinition
implements JsonIntegerProperty {
    private boolean exclusiveMinimum = false;
    private boolean exclusiveMaximum = false;
    private Integer minimum = null;
    private Integer maximum = null;

    public StructrIntegerProperty(StructrTypeDefinition parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    @Override
    public JsonIntegerProperty setExclusiveMinimum(boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    @Override
    public boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    @Override
    public JsonIntegerProperty setExclusiveMaximum(boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    @Override
    public Integer getMinimum() {
        return this.minimum;
    }

    @Override
    public JsonIntegerProperty setMinimum(int minimum) {
        return this.setMinimum(minimum, false);
    }

    @Override
    public JsonIntegerProperty setMinimum(int minimum, boolean exclusive) {
        this.exclusiveMinimum = exclusive;
        this.minimum = minimum;
        return this;
    }

    @Override
    public Integer getMaximum() {
        return this.maximum;
    }

    @Override
    public JsonIntegerProperty setMaximum(int maximum) {
        return this.setMaximum(maximum, false);
    }

    @Override
    public JsonIntegerProperty setMaximum(int maximum, boolean exclusive) {
        this.exclusiveMaximum = exclusive;
        this.maximum = maximum;
        return this;
    }

    @Override
    Map<String, Object> serialize() {
        Map<String, Object> map = super.serialize();
        if (this.exclusiveMinimum) {
            map.put("exclusiveMinimum", true);
        }
        if (this.exclusiveMaximum) {
            map.put("exclusiveMaximum", true);
        }
        if (this.minimum != null) {
            map.put("minimum", this.minimum);
        }
        if (this.maximum != null) {
            map.put("maximum", this.maximum);
        }
        return map;
    }

    @Override
    void deserialize(Map<String, Object> source) {
        Object _maximum;
        Object _minimum;
        Object _exclusiveMaximum;
        super.deserialize(source);
        Object _exclusiveMinimum = source.get("exclusiveMinimum");
        if (_exclusiveMinimum != null && Boolean.TRUE.equals(_exclusiveMinimum)) {
            this.exclusiveMinimum = true;
        }
        if ((_exclusiveMaximum = source.get("exclusiveMaximum")) != null && Boolean.TRUE.equals(_exclusiveMaximum)) {
            this.exclusiveMaximum = true;
        }
        if ((_minimum = source.get("minimum")) != null && _minimum instanceof Number) {
            this.minimum = ((Number)_minimum).intValue();
        }
        if ((_maximum = source.get("maximum")) != null && _maximum instanceof Number) {
            this.maximum = ((Number)_maximum).intValue();
        }
    }

    @Override
    void deserialize(SchemaProperty property) {
        super.deserialize(property);
        IntPropertyParser intPropertyParser = property.getIntPropertyParser();
        if (intPropertyParser != null) {
            Number max;
            this.exclusiveMinimum = intPropertyParser.isLowerExclusive();
            this.exclusiveMaximum = intPropertyParser.isUpperExclusive();
            Number min = intPropertyParser.getLowerBound();
            if (min != null) {
                this.minimum = min.intValue();
            }
            if ((max = intPropertyParser.getUpperBound()) != null) {
                this.maximum = max.intValue();
            }
        }
    }

    @Override
    SchemaProperty createDatabaseSchema(App app, AbstractSchemaNode schemaNode) throws FrameworkException {
        SchemaProperty property = super.createDatabaseSchema(app, schemaNode);
        property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.Integer.name());
        if (this.minimum != null && this.maximum != null) {
            StringBuilder range = new StringBuilder();
            if (this.exclusiveMinimum) {
                range.append("]");
            } else {
                range.append("[");
            }
            range.append(this.minimum);
            range.append(",");
            range.append(this.maximum);
            if (this.exclusiveMaximum) {
                range.append("[");
            } else {
                range.append("]");
            }
            property.setProperty(SchemaProperty.format, range.toString());
        }
        return property;
    }

    @Override
    public String getType() {
        return "integer";
    }
}

