/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.net.URI;
import java.util.Map;
import java.util.TreeMap;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.Relation;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.entity.relationship.SchemaRelationship;
import org.structr.schema.export.StructrReferenceProperty;
import org.structr.schema.export.StructrSchemaDefinition;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonProperty;
import org.structr.schema.json.JsonReferenceProperty;
import org.structr.schema.json.JsonReferenceType;
import org.structr.schema.json.JsonSchema;
import org.structr.schema.json.JsonType;

public class StructrRelationshipTypeDefinition
extends StructrTypeDefinition<SchemaRelationshipNode>
implements JsonReferenceType {
    private JsonReferenceProperty sourceReference = null;
    private JsonReferenceProperty targetReference = null;
    private String sourcePropertyName = null;
    private String targetPropertyName = null;
    private String relationshipType = null;
    private URI sourceType = null;
    private URI targetType = null;
    private Relation.Cardinality cardinality = null;
    private JsonSchema.Cascade cascadingDelete = null;
    private JsonSchema.Cascade cascadingCreate = null;
    private String aclResolution = null;
    private String aclReadMask = null;
    private String aclWriteMask = null;
    private String aclDeleteMask = null;
    private String aclAccessControlMask = null;
    private String aclHiddenProperties = null;

    public StructrRelationshipTypeDefinition(StructrSchemaDefinition root, String name) {
        super(root, name);
    }

    @Override
    public String getRelationship() {
        return this.relationshipType;
    }

    @Override
    public JsonReferenceType setRelationship(String relationship) {
        this.relationshipType = relationship;
        return this;
    }

    @Override
    public JsonReferenceType setCardinality(Relation.Cardinality cardinality) {
        this.cardinality = cardinality;
        return this;
    }

    @Override
    public Relation.Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public URI getSourceType() {
        return this.sourceType;
    }

    @Override
    public URI getTargetType() {
        return this.targetType;
    }

    @Override
    public JsonReferenceType setSourcePropertyName(String sourcePropertyName) {
        this.sourcePropertyName = sourcePropertyName;
        return this;
    }

    @Override
    public String getSourcePropertyName() {
        return this.sourcePropertyName;
    }

    @Override
    public JsonReferenceType setTargetPropertyName(String targetPropertyName) {
        this.targetPropertyName = targetPropertyName;
        return this;
    }

    @Override
    public String getTargetPropertyName() {
        return this.targetPropertyName;
    }

    @Override
    public JsonReferenceProperty getSourceProperty() {
        return this.sourceReference;
    }

    @Override
    public JsonReferenceProperty getTargetProperty() {
        return this.targetReference;
    }

    @Override
    public JsonSchema.Cascade getCascadingDelete() {
        return this.cascadingDelete;
    }

    @Override
    public JsonSchema.Cascade getCascadingCreate() {
        return this.cascadingCreate;
    }

    @Override
    public JsonReferenceType setCascadingDelete(JsonSchema.Cascade cascade) {
        this.cascadingDelete = cascade;
        return this;
    }

    @Override
    public JsonReferenceType setCascadingCreate(JsonSchema.Cascade cascade) {
        this.cascadingCreate = cascade;
        return this;
    }

    @Override
    Map<String, Object> serialize() {
        Map<String, Object> map = super.serialize();
        map.put("rel", this.relationshipType);
        map.put("$source", this.root.toJsonPointer(this.sourceType));
        map.put("$target", this.root.toJsonPointer(this.targetType));
        map.put("sourceName", this.sourcePropertyName);
        map.put("targetName", this.targetPropertyName);
        if (!SchemaRelationshipNode.Direction.None.name().equals(this.aclResolution)) {
            map.put("aclResolution", this.aclResolution);
            if (!SchemaRelationshipNode.Propagation.Remove.name().equals(this.aclReadMask)) {
                map.put("aclReadMask", this.aclReadMask);
            }
            if (!SchemaRelationshipNode.Propagation.Remove.name().equals(this.aclWriteMask)) {
                map.put("aclWriteMask", this.aclWriteMask);
            }
            if (!SchemaRelationshipNode.Propagation.Remove.name().equals(this.aclDeleteMask)) {
                map.put("aclDeleteMask", this.aclDeleteMask);
            }
            if (!SchemaRelationshipNode.Propagation.Remove.name().equals(this.aclAccessControlMask)) {
                map.put("aclAccessControlMask", this.aclAccessControlMask);
            }
            if (this.aclHiddenProperties != null) {
                map.put("aclHiddenProperties", this.aclHiddenProperties);
            }
        }
        TreeMap<String, String> cascade = new TreeMap<String, String>();
        if (this.cascadingCreate != null) {
            cascade.put("create", this.cascadingCreate.name());
        }
        if (this.cascadingDelete != null) {
            cascade.put("delete", this.cascadingDelete.name());
        }
        if (!cascade.isEmpty()) {
            map.put("cascade", cascade);
        }
        if (this.cardinality != null && !Relation.Cardinality.ManyToMany.equals((Object)this.cardinality)) {
            map.put("cardinality", this.cardinality.name());
        }
        return map;
    }

    @Override
    void deserialize(Map<String, Object> source) {
        Object aclHiddenPropertiesValue;
        Object aclAccessControlMaskValue;
        Object aclDeleteMaskValue;
        Object aclWriteMaskValue;
        Object aclReadMaskValue;
        Object aclResolutionValue;
        Object cascadeObject;
        Object targetNameValue;
        Object cardinalityValue;
        Object targetValue;
        Object sourceValue;
        super.deserialize(source);
        Object relValue = source.get("rel");
        if (relValue != null && relValue instanceof String) {
            this.relationshipType = relValue.toString();
        }
        if ((sourceValue = source.get("$source")) != null && sourceValue instanceof String) {
            String sourceURI = sourceValue.toString();
            if (sourceURI.startsWith("#/")) {
                sourceURI = sourceURI.substring(2);
            }
            this.sourceType = this.root.getId().resolve(URI.create(sourceURI));
        }
        if ((targetValue = source.get("$target")) != null && targetValue instanceof String) {
            String targetURI = targetValue.toString();
            if (targetURI.startsWith("#/")) {
                targetURI = targetURI.substring(2);
            }
            this.targetType = this.root.getId().resolve(URI.create(targetURI));
        }
        this.cardinality = (cardinalityValue = source.get("cardinality")) != null ? Relation.Cardinality.valueOf(cardinalityValue.toString()) : Relation.Cardinality.ManyToMany;
        Object sourceNameValue = source.get("sourceName");
        if (sourceNameValue != null) {
            this.sourcePropertyName = sourceNameValue.toString();
        }
        if ((targetNameValue = source.get("targetName")) != null) {
            this.targetPropertyName = targetNameValue.toString();
        }
        if ((cascadeObject = source.get("cascade")) != null) {
            if (cascadeObject instanceof Map) {
                Object createValue;
                Map cascade = (Map)cascadeObject;
                Object deleteValue = cascade.get("delete");
                if (deleteValue != null && deleteValue instanceof String) {
                    this.cascadingDelete = JsonSchema.Cascade.valueOf(deleteValue.toString());
                }
                if ((createValue = cascade.get("create")) != null && createValue instanceof String) {
                    this.cascadingCreate = JsonSchema.Cascade.valueOf(createValue.toString());
                }
            } else {
                throw new IllegalStateException("Invalid JSON source for cascade, expected object.");
            }
        }
        if ((aclResolutionValue = source.get("aclResolution")) != null) {
            this.aclResolution = aclResolutionValue.toString();
        }
        if ((aclReadMaskValue = source.get("aclReadMask")) != null) {
            this.aclReadMask = aclReadMaskValue.toString();
        }
        if ((aclWriteMaskValue = source.get("aclWriteMask")) != null) {
            this.aclWriteMask = aclWriteMaskValue.toString();
        }
        if ((aclDeleteMaskValue = source.get("aclDeleteMask")) != null) {
            this.aclDeleteMask = aclDeleteMaskValue.toString();
        }
        if ((aclAccessControlMaskValue = source.get("aclAccessControlMask")) != null) {
            this.aclAccessControlMask = aclAccessControlMaskValue.toString();
        }
        if ((aclHiddenPropertiesValue = source.get("aclHiddenProperties")) != null) {
            this.aclHiddenProperties = aclHiddenPropertiesValue.toString();
        }
    }

    @Override
    void deserialize(SchemaRelationshipNode schemaNode) {
        Long cascadingCreateFlag;
        Long cascadingDeleteFlag;
        super.deserialize(schemaNode);
        SchemaNode sourceNode = schemaNode.getProperty(SchemaRelationshipNode.sourceNode);
        SchemaNode targetNode = schemaNode.getProperty(SchemaRelationshipNode.targetNode);
        String sourceNodeType = sourceNode.getClassName();
        String targetNodeType = targetNode.getClassName();
        this.sourceType = this.root.getId().resolve("definitions/" + sourceNodeType);
        this.targetType = this.root.getId().resolve("definitions/" + targetNodeType);
        this.relationshipType = schemaNode.getProperty(SchemaRelationshipNode.relationshipType);
        this.sourcePropertyName = schemaNode.getProperty(SchemaRelationshipNode.sourceJsonName);
        this.targetPropertyName = schemaNode.getProperty(SchemaRelationshipNode.targetJsonName);
        this.aclResolution = schemaNode.getProperty(SchemaRelationshipNode.permissionPropagation).name();
        this.aclReadMask = schemaNode.getProperty(SchemaRelationshipNode.readPropagation).name();
        this.aclWriteMask = schemaNode.getProperty(SchemaRelationshipNode.writePropagation).name();
        this.aclDeleteMask = schemaNode.getProperty(SchemaRelationshipNode.deletePropagation).name();
        this.aclAccessControlMask = schemaNode.getProperty(SchemaRelationshipNode.accessControlPropagation).name();
        this.aclHiddenProperties = schemaNode.getProperty(SchemaRelationshipNode.propertyMask);
        if (this.sourcePropertyName == null) {
            this.sourcePropertyName = schemaNode.getPropertyName(sourceNodeType, this.root.getExistingPropertyNames(), false);
        }
        if (this.targetPropertyName == null) {
            this.targetPropertyName = schemaNode.getPropertyName(targetNodeType, this.root.getExistingPropertyNames(), true);
        }
        if ((cascadingDeleteFlag = schemaNode.getProperty(SchemaRelationshipNode.cascadingDeleteFlag)) != null) {
            this.cascadingDelete = this.getCascadingString(cascadingDeleteFlag.intValue());
        }
        if ((cascadingCreateFlag = schemaNode.getProperty(SchemaRelationshipNode.autocreationFlag)) != null) {
            this.cascadingCreate = this.getCascadingString(cascadingCreateFlag.intValue());
        }
        String sourceMultiplicity = schemaNode.getProperty(SchemaRelationship.sourceMultiplicity);
        String targetMultiplicity = schemaNode.getProperty(SchemaRelationship.targetMultiplicity);
        this.cardinality = "1".equals(sourceMultiplicity) ? ("1".equals(targetMultiplicity) ? Relation.Cardinality.OneToOne : Relation.Cardinality.OneToMany) : ("1".equals(targetMultiplicity) ? Relation.Cardinality.ManyToOne : Relation.Cardinality.ManyToMany);
    }

    @Override
    SchemaRelationshipNode createSchemaNode(App app) throws FrameworkException {
        SchemaRelationshipNode _schemaNode = app.create(SchemaRelationshipNode.class, this.getName());
        _schemaNode.setProperty(SchemaRelationshipNode.relationshipType, this.getRelationship());
        _schemaNode.setProperty(SchemaRelationshipNode.sourceJsonName, this.sourcePropertyName);
        _schemaNode.setProperty(SchemaRelationshipNode.targetJsonName, this.targetPropertyName);
        _schemaNode.setProperty(SchemaRelationshipNode.sourceMultiplicity, this.getSourceMultiplicity(this.cardinality));
        _schemaNode.setProperty(SchemaRelationshipNode.targetMultiplicity, this.getTargetMultiplicity(this.cardinality));
        _schemaNode.setProperty(SchemaRelationshipNode.cascadingDeleteFlag, this.getCascadingFlag(this.cascadingDelete));
        _schemaNode.setProperty(SchemaRelationshipNode.autocreationFlag, this.getCascadingFlag(this.cascadingCreate));
        if (this.aclResolution != null) {
            _schemaNode.setProperty(SchemaRelationshipNode.permissionPropagation, SchemaRelationshipNode.Direction.valueOf(this.aclResolution));
        }
        if (this.aclReadMask != null) {
            _schemaNode.setProperty(SchemaRelationshipNode.readPropagation, SchemaRelationshipNode.Propagation.valueOf(this.aclReadMask));
        }
        if (this.aclWriteMask != null) {
            _schemaNode.setProperty(SchemaRelationshipNode.writePropagation, SchemaRelationshipNode.Propagation.valueOf(this.aclWriteMask));
        }
        if (this.aclDeleteMask != null) {
            _schemaNode.setProperty(SchemaRelationshipNode.deletePropagation, SchemaRelationshipNode.Propagation.valueOf(this.aclDeleteMask));
        }
        if (this.aclAccessControlMask != null) {
            _schemaNode.setProperty(SchemaRelationshipNode.accessControlPropagation, SchemaRelationshipNode.Propagation.valueOf(this.aclAccessControlMask));
        }
        if (this.aclHiddenProperties != null) {
            _schemaNode.setProperty(SchemaRelationshipNode.propertyMask, this.aclHiddenProperties);
        }
        return _schemaNode;
    }

    void resolveEndpointTypesForDatabaseSchemaCreation(App app) throws FrameworkException {
        SchemaNode thisSchemaRelationship;
        SchemaNode sourceSchemaNode = this.resolveSchemaNode(app, this.sourceType);
        SchemaNode targetSchemaNode = this.resolveSchemaNode(app, this.targetType);
        if (sourceSchemaNode != null && targetSchemaNode != null) {
            thisSchemaRelationship = this.getSchemaNode();
            if (thisSchemaRelationship == null) {
                throw new IllegalStateException("Unable to resolve schema node endpoints for type " + this.getName());
            }
        } else {
            throw new IllegalStateException("Unable to resolve schema node endpoints for type " + this.getName());
        }
        thisSchemaRelationship.setProperty(SchemaRelationshipNode.sourceNode, (SchemaNode)sourceSchemaNode);
        thisSchemaRelationship.setProperty(SchemaRelationshipNode.targetNode, (SchemaNode)targetSchemaNode);
    }

    Map<String, Object> serializeRelationshipProperty(boolean outgoing) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        TreeMap<String, String> items = new TreeMap<String, String>();
        if (outgoing) {
            switch (this.cardinality) {
                case OneToOne: 
                case ManyToOne: {
                    map.put("type", "object");
                    map.put("$ref", this.root.toJsonPointer(this.targetType));
                    break;
                }
                case OneToMany: 
                case ManyToMany: {
                    map.put("type", "array");
                    map.put("items", items);
                    items.put("$ref", this.root.toJsonPointer(this.targetType));
                }
            }
        } else {
            switch (this.cardinality) {
                case OneToOne: 
                case OneToMany: {
                    map.put("type", "object");
                    map.put("$ref", this.root.toJsonPointer(this.sourceType));
                    break;
                }
                case ManyToOne: 
                case ManyToMany: {
                    map.put("type", "array");
                    map.put("items", items);
                    items.put("$ref", this.root.toJsonPointer(this.sourceType));
                }
            }
        }
        map.put("$link", this.root.toJsonPointer(this.getId()));
        return map;
    }

    void setSourceType(URI sourceType) {
        Object type = this.root.resolveURI(sourceType);
        if (type instanceof StructrTypeDefinition) {
            this.sourceReference = new SourcePropertyReference((StructrTypeDefinition)type, this.sourcePropertyName);
        }
        this.sourceType = sourceType;
    }

    void setTargetType(URI targetType) {
        Object type = this.root.resolveURI(targetType);
        if (type instanceof StructrTypeDefinition) {
            this.targetReference = new TargetPropertyReference((StructrTypeDefinition)type, this.targetPropertyName);
        }
        this.targetType = targetType;
    }

    private String getSourceMultiplicity(Relation.Cardinality cardinality) {
        switch (cardinality) {
            case OneToOne: 
            case OneToMany: {
                return "1";
            }
            case ManyToOne: 
            case ManyToMany: {
                return "*";
            }
        }
        return null;
    }

    private String getTargetMultiplicity(Relation.Cardinality cardinality) {
        switch (cardinality) {
            case OneToOne: 
            case ManyToOne: {
                return "1";
            }
            case OneToMany: 
            case ManyToMany: {
                return "*";
            }
        }
        return null;
    }

    private JsonSchema.Cascade getCascadingString(int cascadingFlag) {
        switch (cascadingFlag) {
            case 0: {
                return null;
            }
            case 1: {
                return JsonSchema.Cascade.sourceToTarget;
            }
            case 2: {
                return JsonSchema.Cascade.targetToSource;
            }
            case 3: {
                return JsonSchema.Cascade.always;
            }
        }
        return null;
    }

    private long getCascadingFlag(JsonSchema.Cascade cascade) {
        if (cascade != null) {
            switch (cascade) {
                case sourceToTarget: {
                    return 1L;
                }
                case targetToSource: {
                    return 2L;
                }
                case always: {
                    return 3L;
                }
            }
        }
        return 0L;
    }

    private class TargetPropertyReference
    extends StructrReferenceProperty {
        private TargetPropertyReference(JsonType parent, String name) {
            super(parent, name);
        }

        @Override
        public URI getId() {
            return URI.create(StructrRelationshipTypeDefinition.this.sourceType.toString() + "/properties/" + this.getName());
        }

        @Override
        public String getName() {
            return StructrRelationshipTypeDefinition.this.targetPropertyName;
        }

        @Override
        public String getType() {
            switch (StructrRelationshipTypeDefinition.this.cardinality) {
                case OneToOne: 
                case ManyToOne: {
                    return "object";
                }
                case OneToMany: 
                case ManyToMany: {
                    return "array";
                }
            }
            return null;
        }

        @Override
        public JsonProperty setName(String name) {
            StructrRelationshipTypeDefinition.this.targetPropertyName = name;
            return this;
        }
    }

    private class SourcePropertyReference
    extends StructrReferenceProperty {
        private SourcePropertyReference(JsonType parent, String name) {
            super(parent, name);
        }

        @Override
        public URI getId() {
            return URI.create(StructrRelationshipTypeDefinition.this.targetType.toString() + "/properties/" + this.getName());
        }

        @Override
        public String getName() {
            return StructrRelationshipTypeDefinition.this.sourcePropertyName;
        }

        @Override
        public String getType() {
            switch (StructrRelationshipTypeDefinition.this.cardinality) {
                case OneToOne: 
                case OneToMany: {
                    return "object";
                }
                case ManyToOne: 
                case ManyToMany: {
                    return "array";
                }
            }
            return null;
        }

        @Override
        public JsonProperty setName(String name) {
            StructrRelationshipTypeDefinition.this.sourcePropertyName = name;
            return this;
        }
    }
}

