/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.export.StructrPropertyDefinition;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonScriptProperty;

public class StructrScriptProperty
extends StructrPropertyDefinition
implements JsonScriptProperty {
    protected String contentType = null;
    protected String source = null;

    public StructrScriptProperty(StructrTypeDefinition parent, String name) {
        super(parent, name);
    }

    @Override
    public JsonScriptProperty setSource(String source) {
        this.source = source;
        return this;
    }

    @Override
    public String getType() {
        return "script";
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public JsonScriptProperty setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    Map<String, Object> serialize() {
        Map<String, Object> map = super.serialize();
        if (this.source != null) {
            map.put("source", this.source);
        }
        if (this.contentType != null) {
            map.put("contentType", this.contentType);
        }
        return map;
    }

    @Override
    void deserialize(Map<String, Object> source) {
        super.deserialize(source);
        Object sourceValue = source.get("source");
        if (sourceValue != null) {
            if (!(sourceValue instanceof String)) {
                throw new IllegalStateException("Invalid source for property " + this.name + ", expected string.");
            }
        } else {
            throw new IllegalStateException("Missing source value for property " + this.name);
        }
        this.source = (String)sourceValue;
        Object contentTypeValue = source.get("contentType");
        if (contentTypeValue != null) {
            if (contentTypeValue instanceof String) {
                this.contentType = (String)contentTypeValue;
            } else {
                throw new IllegalStateException("Invalid contentType for property " + this.name + ", expected string.");
            }
        }
    }

    @Override
    void deserialize(SchemaProperty property) {
        super.deserialize(property);
        this.setContentType(property.getSourceContentType());
        this.setSource(property.getFormat());
    }

    @Override
    SchemaProperty createDatabaseSchema(App app, AbstractSchemaNode schemaNode) throws FrameworkException {
        SchemaProperty property = super.createDatabaseSchema(app, schemaNode);
        String contentType = this.getContentType();
        if (contentType != null) {
            switch (contentType) {
                case "application/x-structr-javascript": 
                case "application/x-structr-script": {
                    property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.Function.name());
                    break;
                }
                case "application/x-cypher": {
                    property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.Cypher.name());
                }
            }
        } else {
            property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.Function.name());
        }
        property.setProperty(SchemaProperty.format, this.source);
        return property;
    }
}

