/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.export.StructrPropertyDefinition;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonStringProperty;

public class StructrStringProperty
extends StructrPropertyDefinition
implements JsonStringProperty {
    private String contentType;

    public StructrStringProperty(StructrTypeDefinition parent, String name) {
        super(parent, name);
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    void deserialize(Map<String, Object> source) {
        super.deserialize(source);
        if (source.containsKey("contentType")) {
            this.contentType = (String)source.get("contentType");
        }
        if (source.containsKey("format")) {
            this.format = (String)source.get("format");
        }
    }

    @Override
    void deserialize(SchemaProperty property) {
        super.deserialize(property);
        this.setFormat(property.getFormat());
        this.setContentType(property.getContentType());
    }

    @Override
    Map<String, Object> serialize() {
        Map<String, Object> map = super.serialize();
        if (this.contentType != null) {
            map.put("contentType", this.contentType);
        }
        if (this.format != null) {
            map.put("format", this.format);
        }
        return map;
    }

    @Override
    SchemaProperty createDatabaseSchema(App app, AbstractSchemaNode schemaNode) throws FrameworkException {
        SchemaProperty property = super.createDatabaseSchema(app, schemaNode);
        property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.String.name());
        property.setProperty(SchemaProperty.format, this.getFormat());
        property.setProperty(SchemaProperty.contentType, this.getContentType());
        return property;
    }

    @Override
    public JsonStringProperty setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }
}

