/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.schema.export.StructrDefinition;
import org.structr.schema.export.StructrNodeTypeDefinition;
import org.structr.schema.export.StructrRelationshipTypeDefinition;
import org.structr.schema.export.StructrSchemaDefinition;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonObjectType;
import org.structr.schema.json.JsonType;

public class StructrTypeDefinitions
implements StructrDefinition {
    private final Set<StructrRelationshipTypeDefinition> relationships = new TreeSet<StructrRelationshipTypeDefinition>();
    private final Set<StructrTypeDefinition> typeDefinitions = new TreeSet<StructrTypeDefinition>();
    private StructrSchemaDefinition root = null;

    StructrTypeDefinitions(StructrSchemaDefinition root) {
        this.root = root;
    }

    public Set<StructrTypeDefinition> getTypes() {
        return this.typeDefinitions;
    }

    public JsonType getType(String name) {
        for (JsonType jsonType : this.typeDefinitions) {
            if (!name.equals(jsonType.getName())) continue;
            return jsonType;
        }
        return null;
    }

    public JsonObjectType addType(String name) {
        StructrNodeTypeDefinition def = new StructrNodeTypeDefinition(this.root, name);
        this.typeDefinitions.add(def);
        return def;
    }

    public void removeType(String name) {
        StructrNodeTypeDefinition def = new StructrNodeTypeDefinition(this.root, name);
        this.typeDefinitions.remove(def);
    }

    public void createDatabaseSchema(App app) throws FrameworkException {
        for (StructrTypeDefinition type : this.typeDefinitions) {
            AbstractSchemaNode schemaNode = type.createDatabaseSchema(app);
            if (schemaNode == null) continue;
            type.setSchemaNode(schemaNode);
        }
        for (StructrRelationshipTypeDefinition rel : this.relationships) {
            rel.resolveEndpointTypesForDatabaseSchemaCreation(app);
        }
    }

    @Override
    public StructrDefinition resolveJsonPointerKey(String key) {
        for (StructrTypeDefinition type : this.typeDefinitions) {
            if (!key.equals(type.getName())) continue;
            return type;
        }
        return null;
    }

    Map<String, Object> serialize() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (StructrTypeDefinition type : this.typeDefinitions) {
            map.put(type.getName(), type.serialize());
        }
        return map;
    }

    void deserialize(Map<String, Object> source) {
        this.deserialize(source, null);
    }

    void deserialize(Map<String, Object> source, List<String> nodeIds) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map map = (Map)value;
                StructrTypeDefinition type = StructrTypeDefinition.deserialize(this.root, name, map);
                if (type == null) continue;
                this.typeDefinitions.add(type);
                if (!(type instanceof StructrRelationshipTypeDefinition)) continue;
                this.relationships.add((StructrRelationshipTypeDefinition)type);
                continue;
            }
            throw new IllegalStateException("Invalid JSON object for " + name + ", expected object, got " + value.getClass().getSimpleName());
        }
        for (StructrTypeDefinition type : this.typeDefinitions) {
            type.initializeReferenceProperties();
        }
    }

    void deserialize(App app) throws FrameworkException {
        StructrTypeDefinition type;
        for (SchemaNode schemaNode : app.nodeQuery(SchemaNode.class).getAsList()) {
            type = StructrTypeDefinition.deserialize(this.root, schemaNode);
            if (type == null) continue;
            this.typeDefinitions.add(type);
        }
        for (SchemaRelationshipNode schemaRelationship : app.nodeQuery(SchemaRelationshipNode.class).getAsList()) {
            type = StructrTypeDefinition.deserialize(this.root, schemaRelationship);
            if (type == null) continue;
            this.typeDefinitions.add(type);
            if (!(type instanceof StructrRelationshipTypeDefinition)) continue;
            this.relationships.add((StructrRelationshipTypeDefinition)type);
        }
    }

    void addType(StructrTypeDefinition type) {
        this.typeDefinitions.add(type);
    }

    void removeType(StructrTypeDefinition type) {
        this.typeDefinitions.remove(type);
    }

    Set<StructrRelationshipTypeDefinition> getRelationships() {
        return this.relationships;
    }
}

