/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.importer;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.structr.schema.importer.LazyFileBasedLongCollection;

public class FileBasedHashLongMap<K> {
    private final Map<K, LazyFileBasedLongCollection> hashFiles = new LinkedHashMap<K, LazyFileBasedLongCollection>();
    private boolean clearOnOpen = true;
    private String basePath = null;

    public FileBasedHashLongMap(String basePath) {
        this(basePath, true);
    }

    public FileBasedHashLongMap(String basePath, boolean clearOnOpen) {
        this.basePath = basePath;
    }

    public void add(K key, Long value) {
        this.getCollectionForKey(key).add(value);
    }

    public Collection<Long> get(K key) {
        return this.getCollectionForKey(key);
    }

    private LazyFileBasedLongCollection getCollectionForKey(K key) {
        LazyFileBasedLongCollection collection = this.hashFiles.get(key);
        if (collection == null) {
            collection = new LazyFileBasedLongCollection(this.basePath + File.separator + key.hashCode() + ".lfc", this.clearOnOpen);
            this.hashFiles.put(key, collection);
        }
        return collection;
    }
}

