/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.importer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.structr.api.graph.Label;
import org.structr.api.graph.Node;

public class NodeInfo {
    private final Map<String, Class> properties = new LinkedHashMap<String, Class>();
    private final Set<String> types = new LinkedHashSet<String>();
    private int hashCode = 0;

    public NodeInfo(Node node) {
        this.extractProperties(node);
        this.extractTypes(node);
        this.calcHashCode();
    }

    private void calcHashCode() {
        this.hashCode = 13;
        this.hashCode += this.types.hashCode();
        this.hashCode += this.properties.hashCode() * 31;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other instanceof NodeInfo) {
            return this.hashCode() == other.hashCode();
        }
        return false;
    }

    public boolean hasType(String type) {
        return this.types.contains(type);
    }

    public Map<String, Class> getProperties() {
        return this.properties;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    private void extractProperties(Node node) {
        for (String key : node.getPropertyKeys()) {
            Object value = node.getProperty(key);
            if (value == null) continue;
            this.properties.put(key, value.getClass());
        }
    }

    private void extractTypes(Node node) {
        ArrayList<String> labelStrings = new ArrayList<String>();
        for (Label label : node.getLabels()) {
            labelStrings.add(label.name());
        }
        this.addType(StringUtils.join(labelStrings, (String)""));
        if (node.hasProperty("type")) {
            String type = node.getProperty("type").toString();
            this.addType(type.replaceAll("[\\W]+", ""));
        }
        if (this.types.isEmpty() && !this.properties.keySet().isEmpty()) {
            StringBuilder buf = new StringBuilder("NodeWith");
            for (String key : this.properties.keySet()) {
                buf.append(StringUtils.capitalize((String)key));
            }
            this.types.add(buf.toString());
        }
    }

    private void addType(String type) {
        if (type != null && !type.equals("")) {
            this.types.add(type);
        }
    }
}

