/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.InvalidPropertySchemaToken;
import org.structr.core.entity.SchemaNode;
import org.structr.core.property.DoubleProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.NumericalPropertyParser;
import org.structr.schema.parser.PropertyDefinition;

public class DoublePropertyParser
extends NumericalPropertyParser {
    public DoublePropertyParser(ErrorBuffer errorBuffer, String className, PropertyDefinition params) {
        super(errorBuffer, className, params);
    }

    @Override
    public String getPropertyType() {
        return DoubleProperty.class.getSimpleName();
    }

    @Override
    public String getValueType() {
        return Double.class.getName();
    }

    @Override
    public String getUnqualifiedValueType() {
        return "Double";
    }

    @Override
    public SchemaHelper.Type getKey() {
        return SchemaHelper.Type.Double;
    }

    @Override
    public Number parseNumber(ErrorBuffer errorBuffer, String source, String which) {
        try {
            return Double.parseDouble(source);
        }
        catch (Throwable t) {
            this.reportError(new InvalidPropertySchemaToken(SchemaNode.class.getSimpleName(), source, "invalid_" + which + "_bound", StringUtils.capitalize((String)which) + " bound must be of type Double."));
            return null;
        }
    }

    @Override
    public String getDefaultValue() {
        return this.getSourceDefaultValue().concat("d");
    }
}

